/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightField
extends LightElement
implements PsiField {
    private final PsiField myField;
    private final PsiClass myContainingClass;

    public LightField(@NotNull PsiManager manager, @NotNull PsiField field, @NotNull PsiClass containingClass) {
        super(manager, (Language)JavaLanguage.INSTANCE);
        this.myField = field;
        this.myContainingClass = containingClass;
    }

    public void setInitializer(@Nullable PsiExpression initializer) throws IncorrectOperationException {
        throw new IncorrectOperationException("Not supported");
    }

    @NotNull
    public SearchScope getUseScope() {
        return this.myField.getUseScope();
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo(this, another);
    }

    public String getName() {
        return this.myField.getName();
    }

    @NotNull
    public PsiIdentifier getNameIdentifier() {
        return this.myField.getNameIdentifier();
    }

    public PsiDocComment getDocComment() {
        return this.myField.getDocComment();
    }

    public boolean isDeprecated() {
        return this.myField.isDeprecated();
    }

    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    @NotNull
    public PsiType getType() {
        return this.myField.getType();
    }

    public PsiTypeElement getTypeElement() {
        return this.myField.getTypeElement();
    }

    public PsiExpression getInitializer() {
        return this.myField.getInitializer();
    }

    public boolean hasInitializer() {
        return this.myField.hasInitializer();
    }

    public void normalizeDeclaration() throws IncorrectOperationException {
        throw new IncorrectOperationException("Not supported");
    }

    public Object computeConstantValue() {
        return this.myField.computeConstantValue();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Not supported");
    }

    public PsiModifierList getModifierList() {
        return this.myField.getModifierList();
    }

    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        return this.myField.hasModifierProperty(name);
    }

    public String getText() {
        return this.myField.getText();
    }

    public PsiElement copy() {
        return new LightField(this.myManager, (PsiField)this.myField.copy(), this.myContainingClass);
    }

    public TextRange getTextRange() {
        return this.myField.getTextRange();
    }

    public boolean isValid() {
        return this.myContainingClass.isValid();
    }

    public String toString() {
        return "PsiField:" + this.getName();
    }
}

