/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightJavaModule
extends LightElement
implements PsiJavaModule {
    private final LightJavaModuleReferenceElement myRefElement;
    private final VirtualFile myJarRoot;
    private final NotNullLazyValue<List<PsiPackageAccessibilityStatement>> myExports = AtomicNotNullLazyValue.createValue(() -> this.findExports());

    private LightJavaModule(@NotNull PsiManager manager, @NotNull VirtualFile jarRoot) {
        super(manager, (Language)JavaLanguage.INSTANCE);
        this.myJarRoot = jarRoot;
        this.myRefElement = new LightJavaModuleReferenceElement(manager, LightJavaModule.moduleName(jarRoot));
    }

    @NotNull
    public VirtualFile getRootVirtualFile() {
        return this.myJarRoot;
    }

    @Nullable
    public PsiDocComment getDocComment() {
        return null;
    }

    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        return Collections.emptyList();
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getExports() {
        return (Iterable)this.myExports.getValue();
    }

    private List<PsiPackageAccessibilityStatement> findExports() {
        final ArrayList exports = ContainerUtil.newArrayList();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myJarRoot, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){
            private final JavaDirectoryService service;
            {
                super(x0);
                this.service = JavaDirectoryService.getInstance();
            }

            public boolean visitFile(@NotNull VirtualFile file) {
                String packageName;
                PsiPackage pkg;
                PsiDirectory directory;
                if (file.isDirectory() && !LightJavaModule.this.myJarRoot.equals(file) && (directory = LightJavaModule.this.myManager.findDirectory(file)) != null && (pkg = this.service.getPackage(directory)) != null && !(packageName = pkg.getQualifiedName()).isEmpty() && !PsiUtil.isPackageEmpty((PsiDirectory[])new PsiDirectory[]{directory}, (String)packageName)) {
                    exports.add(new LightPackageAccessibilityStatement(LightJavaModule.this.myManager, packageName));
                }
                return true;
            }
        });
        return exports;
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getOpens() {
        return Collections.emptyList();
    }

    @NotNull
    public Iterable<PsiUsesStatement> getUses() {
        return Collections.emptyList();
    }

    @NotNull
    public Iterable<PsiProvidesStatement> getProvides() {
        return Collections.emptyList();
    }

    @NotNull
    public PsiJavaModuleReferenceElement getNameIdentifier() {
        return this.myRefElement;
    }

    @NotNull
    public String getName() {
        return this.myRefElement.getReferenceText();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        throw new IncorrectOperationException("Cannot modify automatic module '" + this.getName() + "'");
    }

    public PsiModifierList getModifierList() {
        return null;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        return false;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return (PsiElement)ObjectUtils.notNull((Object)this.myManager.findDirectory(this.myJarRoot), (Object)super.getNavigationElement());
    }

    public boolean equals(Object obj) {
        return obj instanceof LightJavaModule && this.myJarRoot.equals(((LightJavaModule)((Object)obj)).myJarRoot) && this.getManager() == ((LightJavaModule)((Object)obj)).getManager();
    }

    public int hashCode() {
        return this.getName().hashCode() * 31 + this.getManager().hashCode();
    }

    public String toString() {
        return "PsiJavaModule:" + this.getName();
    }

    @NotNull
    public static LightJavaModule getModule(@NotNull PsiManager manager, @NotNull VirtualFile jarRoot) {
        PsiDirectory directory = manager.findDirectory(jarRoot);
        assert (directory != null) : jarRoot;
        return (LightJavaModule)((Object)CachedValuesManager.getCachedValue((PsiElement)directory, () -> {
            LightJavaModule module = new LightJavaModule(manager, jarRoot);
            return CachedValueProvider.Result.create((Object)((Object)module), (Object[])new Object[]{directory});
        }));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String moduleName(@NotNull VirtualFile jarRoot) {
        VirtualFile manifest = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifest == null) return LightJavaModule.moduleName(jarRoot.getNameWithoutExtension());
        try (InputStream stream = manifest.getInputStream();){
            String claimed = new Manifest(stream).getMainAttributes().getValue("Automatic-Module-Name");
            if (claimed == null) return LightJavaModule.moduleName(jarRoot.getNameWithoutExtension());
            String string = claimed;
            return string;
        }
        catch (IOException e) {
            Logger.getInstance(LightJavaModule.class).warn((Throwable)e);
        }
        return LightJavaModule.moduleName(jarRoot.getNameWithoutExtension());
    }

    @NotNull
    public static String moduleName(@NotNull String name) {
        Matcher m = Patterns.VERSION.matcher(name);
        if (m.find()) {
            name = name.substring(0, m.start());
        }
        name = Patterns.NON_NAME.matcher(name).replaceAll(".");
        name = Patterns.DOT_SEQUENCE.matcher(name).replaceAll(".");
        name = StringUtil.trimLeading((String)StringUtil.trimTrailing((String)name, (char)'.'), (char)'.');
        return name;
    }

    private static class Patterns {
        private static final Pattern VERSION = Pattern.compile("-(\\d+(\\.|$))");
        private static final Pattern NON_NAME = Pattern.compile("[^A-Za-z0-9]");
        private static final Pattern DOT_SEQUENCE = Pattern.compile("\\.{2,}");

        private Patterns() {
        }
    }

    private static class LightPackageAccessibilityStatement
    extends LightElement
    implements PsiPackageAccessibilityStatement {
        private final String myPackageName;

        private LightPackageAccessibilityStatement(@NotNull PsiManager manager, @NotNull String packageName) {
            super(manager, (Language)JavaLanguage.INSTANCE);
            this.myPackageName = packageName;
        }

        @NotNull
        public PsiPackageAccessibilityStatement.Role getRole() {
            return PsiPackageAccessibilityStatement.Role.EXPORTS;
        }

        @Nullable
        public PsiJavaCodeReferenceElement getPackageReference() {
            return null;
        }

        @Nullable
        public String getPackageName() {
            return this.myPackageName;
        }

        @NotNull
        public Iterable<PsiJavaModuleReferenceElement> getModuleReferences() {
            return Collections.emptyList();
        }

        @NotNull
        public List<String> getModuleNames() {
            return Collections.emptyList();
        }

        public String toString() {
            return "PsiPackageAccessibilityStatement";
        }
    }

    private static class LightJavaModuleReferenceElement
    extends LightElement
    implements PsiJavaModuleReferenceElement {
        private final String myText;

        private LightJavaModuleReferenceElement(@NotNull PsiManager manager, @NotNull String text2) {
            super(manager, (Language)JavaLanguage.INSTANCE);
            this.myText = text2;
        }

        @NotNull
        public String getReferenceText() {
            return this.myText;
        }

        public PsiJavaModuleReference getReference() {
            return null;
        }

        public String toString() {
            return "PsiJavaModuleReference";
        }
    }
}

