/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightReferenceParameterList;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class LightMemberReference
extends LightElement
implements PsiJavaCodeReferenceElement {
    @NotNull
    private final PsiMember myRefMember;
    private final PsiSubstitutor mySubstitutor;
    private LightReferenceParameterList myParameterList;

    public LightMemberReference(@NotNull PsiManager manager, @NotNull PsiMember member, PsiSubstitutor substitutor) {
        super(manager, (Language)JavaLanguage.INSTANCE);
        this.myRefMember = member;
        this.mySubstitutor = substitutor;
    }

    @NotNull
    public PsiElement resolve() {
        return this.myRefMember;
    }

    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        PsiElement resolved = this.resolve();
        PsiSubstitutor substitutor = this.mySubstitutor;
        if (substitutor == null) {
            substitutor = PsiSubstitutor.EMPTY;
        }
        return new CandidateInfo(resolved, substitutor);
    }

    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult result = this.advancedResolve(incompleteCode);
        if (result != JavaResolveResult.EMPTY) {
            return new JavaResolveResult[]{result};
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    public void processVariants(@NotNull PsiScopeProcessor processor) {
        throw new RuntimeException("Variants are not available for light references");
    }

    public PsiElement getReferenceNameElement() {
        return null;
    }

    public PsiReferenceParameterList getParameterList() {
        if (this.myParameterList == null) {
            this.myParameterList = new LightReferenceParameterList(this.myManager, PsiTypeElement.EMPTY_ARRAY);
        }
        return this.myParameterList;
    }

    public String getQualifiedName() {
        String qualifiedName;
        PsiClass containingClass = this.myRefMember.getContainingClass();
        if (containingClass != null && (qualifiedName = containingClass.getQualifiedName()) != null) {
            return qualifiedName + '.' + this.myRefMember.getName();
        }
        return this.myRefMember.getName();
    }

    public String getReferenceName() {
        return this.getQualifiedName();
    }

    public String getText() {
        return this.myRefMember.getName() + this.getParameterList().getText();
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public String getCanonicalText() {
        String name = this.getQualifiedName();
        if (name == null) {
            return null;
        }
        PsiType[] types = this.getTypeParameters();
        if (types.length == 0) {
            return name;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(name);
        buf.append('<');
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(types[i].getCanonicalText());
        }
        buf.append('>');
        return buf.toString();
    }

    public PsiElement copy() {
        return new LightMemberReference(this.myManager, this.myRefMember, this.mySubstitutor);
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement((PsiJavaCodeReferenceElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "LightClassReference:" + this.myRefMember.getName();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        return element instanceof PsiClass && element.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for light references");
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @NotNull
    public PsiElement getElement() {
        return this;
    }

    public boolean isValid() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        if (parameterList != null && !parameterList.isValid()) {
            return false;
        }
        return this.myRefMember == null || this.myRefMember.isValid();
    }

    @NotNull
    public PsiType[] getTypeParameters() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        return parameterList == null ? PsiType.EMPTY_ARRAY : parameterList.getTypeArguments();
    }

    public PsiElement getQualifier() {
        return null;
    }

    public boolean isQualified() {
        return false;
    }
}

