/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.light.LightParameter;
import com.intellij.psi.impl.light.LightParameterListBuilder;
import com.intellij.psi.impl.light.LightReferenceListBuilder;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.impl.light.LightTypeParameterListBuilder;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightMethodBuilder
extends LightElement
implements PsiMethod,
OriginInfoAwareElement {
    private final String myName;
    private Computable<? extends PsiType> myReturnType;
    private final PsiModifierList myModifierList;
    private final PsiParameterList myParameterList;
    private final PsiTypeParameterList myTypeParameterList;
    private final PsiReferenceList myThrowsList;
    private Icon myBaseIcon;
    private PsiClass myContainingClass;
    private boolean myConstructor;
    private String myMethodKind = "LightMethodBuilder";
    private String myOriginInfo;

    public LightMethodBuilder(PsiClass constructedClass, Language language) {
        this(constructedClass.getManager(), language, constructedClass.getName());
        this.setContainingClass(constructedClass);
    }

    public LightMethodBuilder(PsiManager manager, String name) {
        this(manager, (Language)JavaLanguage.INSTANCE, name);
    }

    public LightMethodBuilder(PsiManager manager, Language language, String name) {
        this(manager, language, name, new LightParameterListBuilder(manager, language), new LightModifierList(manager, language, new String[0]));
    }

    public LightMethodBuilder(PsiManager manager, Language language, String name, PsiParameterList parameterList, PsiModifierList modifierList) {
        this(manager, language, name, parameterList, modifierList, new LightReferenceListBuilder(manager, language, PsiReferenceList.Role.THROWS_LIST), new LightTypeParameterListBuilder(manager, language));
    }

    public LightMethodBuilder(PsiManager manager, Language language, String name, PsiParameterList parameterList, PsiModifierList modifierList, PsiReferenceList throwsList, PsiTypeParameterList typeParameterList) {
        super(manager, language);
        this.myName = name;
        this.myParameterList = parameterList;
        this.myModifierList = modifierList;
        this.myThrowsList = throwsList;
        this.myTypeParameterList = typeParameterList;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        return PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
    }

    public PsiTypeParameterList getTypeParameterList() {
        return this.myTypeParameterList;
    }

    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return PsiImplUtil.isDeprecatedByDocTag((PsiJavaDocumentedElement)this) || PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        String className = this.myContainingClass == null ? "null" : this.myContainingClass.getQualifiedName();
        throw new UnsupportedOperationException("Please don't rename light methods: writable=" + this.isWritable() + "; class=" + ((Object)((Object)this)).getClass() + "; name=" + this.getName() + "; inClass=" + className);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        return PsiSuperMethodImplUtil.getHierarchicalMethodSignature(this);
    }

    public boolean hasModifierProperty(@NotNull String name) {
        return this.getModifierList().hasModifierProperty(name);
    }

    @NotNull
    public PsiModifierList getModifierList() {
        return this.myModifierList;
    }

    public LightMethodBuilder addModifiers(String ... modifiers) {
        for (String modifier : modifiers) {
            this.addModifier(modifier);
        }
        return this;
    }

    public LightMethodBuilder addModifier(String modifier) {
        ((LightModifierList)this.myModifierList).addModifier(modifier);
        return this;
    }

    public LightMethodBuilder setModifiers(String ... modifiers) {
        ((LightModifierList)this.myModifierList).clearModifiers();
        this.addModifiers(modifiers);
        return this;
    }

    public PsiType getReturnType() {
        return this.myReturnType == null ? null : (PsiType)this.myReturnType.compute();
    }

    public LightMethodBuilder setMethodReturnType(Computable<? extends PsiType> returnType) {
        this.myReturnType = returnType;
        return this;
    }

    public LightMethodBuilder setMethodReturnType(PsiType returnType) {
        return this.setMethodReturnType((Computable<? extends PsiType>)new Computable.PredefinedValueComputable((Object)returnType));
    }

    public LightMethodBuilder setMethodReturnType(final @NotNull String returnType) {
        return this.setMethodReturnType((Computable<? extends PsiType>)new Computable.NotNullCachedComputable<PsiType>(){

            @NotNull
            protected PsiType internalCompute() {
                return JavaPsiFacade.getElementFactory((Project)LightMethodBuilder.this.myManager.getProject()).createTypeByFQClassName(returnType, LightMethodBuilder.this.getResolveScope());
            }
        });
    }

    public PsiTypeElement getReturnTypeElement() {
        return null;
    }

    @NotNull
    public PsiParameterList getParameterList() {
        return this.myParameterList;
    }

    public LightMethodBuilder addParameter(@NotNull PsiParameter parameter2) {
        ((LightParameterListBuilder)this.myParameterList).addParameter(parameter2);
        return this;
    }

    public LightMethodBuilder addParameter(@NotNull String name, @NotNull String type2) {
        return this.addParameter(name, JavaPsiFacade.getElementFactory((Project)this.getProject()).createTypeFromText(type2, (PsiElement)this));
    }

    public LightMethodBuilder addParameter(@NotNull String name, @NotNull PsiType type2) {
        return this.addParameter(new LightParameter(name, type2, (PsiElement)this, (Language)JavaLanguage.INSTANCE));
    }

    public LightMethodBuilder addParameter(@NotNull String name, @NotNull PsiType type2, boolean isVarArgs) {
        if (isVarArgs && !(type2 instanceof PsiEllipsisType)) {
            type2 = new PsiEllipsisType(type2);
        }
        return this.addParameter(new LightParameter(name, type2, (PsiElement)this, (Language)JavaLanguage.INSTANCE, isVarArgs));
    }

    public LightMethodBuilder addException(PsiClassType type2) {
        ((LightReferenceListBuilder)this.myThrowsList).addReference(type2);
        return this;
    }

    public LightMethodBuilder addException(String fqName) {
        ((LightReferenceListBuilder)this.myThrowsList).addReference(fqName);
        return this;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        return this.myThrowsList;
    }

    public PsiCodeBlock getBody() {
        return null;
    }

    public LightMethodBuilder setConstructor(boolean constructor) {
        this.myConstructor = constructor;
        return this;
    }

    public boolean isConstructor() {
        return this.myConstructor;
    }

    public boolean isVarArgs() {
        return PsiImplUtil.isVarArgs(this);
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        return MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor);
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        return PsiSuperMethodImplUtil.findSuperMethods(this);
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        return PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        return PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic(this, checkAccess);
    }

    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod(this);
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethods(this);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethod((PsiMethod)this);
        }
    }

    public PsiClass getContainingClass() {
        return this.myContainingClass;
    }

    public LightMethodBuilder setContainingClass(PsiClass containingClass) {
        this.myContainingClass = containingClass;
        return this;
    }

    public LightMethodBuilder setMethodKind(String debugKindName) {
        this.myMethodKind = debugKindName;
        return this;
    }

    public String toString() {
        return this.myMethodKind + ":" + this.getName();
    }

    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.myBaseIcon != null ? this.myBaseIcon : (this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON);
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(methodIcon, (PsiModifierListOwner)this, false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public LightMethodBuilder setBaseIcon(Icon baseIcon) {
        this.myBaseIcon = baseIcon;
        return this;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @NotNull
    public SearchScope getUseScope() {
        return PsiImplUtil.getMemberUseScope((PsiMember)this);
    }

    @Nullable
    public PsiFile getContainingFile() {
        PsiClass containingClass = this.getContainingClass();
        return containingClass == null ? null : containingClass.getContainingFile();
    }

    public PsiElement getContext() {
        PsiElement navElement = this.getNavigationElement();
        if (navElement != this) {
            return navElement;
        }
        PsiClass cls = this.getContainingClass();
        if (cls != null) {
            return cls;
        }
        return this.getContainingFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LightMethodBuilder that = (LightMethodBuilder)((Object)o);
        if (this.myConstructor != that.myConstructor) {
            return false;
        }
        if (!Objects.equals(this.myContainingClass, that.myContainingClass)) {
            return false;
        }
        if (!this.myMethodKind.equals(that.myMethodKind)) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        if (!this.getParameterTypes().equals(that.getParameterTypes())) {
            return false;
        }
        return Objects.equals(this.getReturnType(), that.getReturnType());
    }

    public int hashCode() {
        return Objects.hash(this.myName, this.getReturnType(), this.myConstructor, this.myMethodKind, this.myContainingClass, this.getParameterTypes());
    }

    @NotNull
    private List<PsiType> getParameterTypes() {
        return ContainerUtil.map((Object[])this.getParameterList().getParameters(), PsiParameter::getType);
    }

    public LightMethodBuilder addTypeParameter(PsiTypeParameter parameter2) {
        ((LightTypeParameterListBuilder)this.myTypeParameterList).addParameter(new LightTypeParameter(parameter2));
        return this;
    }

    @Nullable
    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    public void setOriginInfo(@Nullable String originInfo) {
        this.myOriginInfo = originInfo;
    }
}

