/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LightModifierList
extends LightElement
implements PsiModifierList {
    private final Set<String> myModifiers;

    public LightModifierList(PsiModifierListOwner modifierListOwner) {
        this(modifierListOwner.getManager());
        this.copyModifiers(modifierListOwner.getModifierList());
    }

    public LightModifierList(PsiManager manager) {
        this(manager, (Language)JavaLanguage.INSTANCE, new String[0]);
    }

    public LightModifierList(PsiManager manager, Language language, String ... modifiers) {
        super(manager, language);
        this.myModifiers = ContainerUtil.newTroveSet((Object[])modifiers);
    }

    public void addModifier(String modifier) {
        this.myModifiers.add(modifier);
    }

    public void copyModifiers(PsiModifierList modifierList) {
        if (modifierList == null) {
            return;
        }
        for (String modifier : PsiModifier.MODIFIERS) {
            if (!modifierList.hasExplicitModifier(modifier)) continue;
            this.addModifier(modifier);
        }
    }

    public void clearModifiers() {
        this.myModifiers.clear();
    }

    public boolean hasModifierProperty(@NotNull String name) {
        return this.myModifiers.contains(name);
    }

    public boolean hasExplicitModifier(@NotNull String name) {
        return this.myModifiers.contains(name);
    }

    public void setModifierProperty(@NotNull String name, boolean value2) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public void checkSetModifierProperty(@NotNull String name, boolean value2) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        return this.getAnnotations();
    }

    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        return null;
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        throw new IncorrectOperationException();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModifierList((PsiModifierList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiModifierList";
    }

    public String getText() {
        StringBuilder buffer = new StringBuilder();
        for (String modifier : PsiModifier.MODIFIERS) {
            if (!this.hasExplicitModifier(modifier)) continue;
            buffer.append(modifier);
            buffer.append(' ');
        }
        if (buffer.length() > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        return buffer.toString();
    }

    @NotNull
    public String[] getModifiers() {
        return ArrayUtil.toStringArray(this.myModifiers);
    }
}

