/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.light.LightElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LightTypeParameterListBuilder
extends LightElement
implements PsiTypeParameterList {
    private final List<PsiTypeParameter> myParameters = new ArrayList<PsiTypeParameter>();
    private PsiTypeParameter[] cached;

    public LightTypeParameterListBuilder(PsiManager manager, Language language) {
        super(manager, language);
    }

    public String toString() {
        return "Light type parameter list";
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeParameterList((PsiTypeParameterList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        if (this.cached == null) {
            this.cached = this.myParameters.isEmpty() ? PsiTypeParameter.EMPTY_ARRAY : this.myParameters.toArray(PsiTypeParameter.EMPTY_ARRAY);
        }
        return this.cached;
    }

    public int getTypeParameterIndex(PsiTypeParameter typeParameter) {
        return this.myParameters.indexOf(typeParameter);
    }

    public void addParameter(PsiTypeParameter parameter2) {
        this.cached = null;
        this.myParameters.add(parameter2);
    }
}

