/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

class HighlightingCaches {
    private final List<Map<?, ?>> allCaches = ContainerUtil.createConcurrentList();
    final ConcurrentMap<PsiClass, PsiClass[]> DIRECT_SUB_CLASSES = this.createWeakCache();
    final ConcurrentMap<PsiClass, Iterable<PsiClass>> ALL_SUB_CLASSES = this.createWeakCache();
    final Map<PsiMethod, Iterable<PsiMethod>> OVERRIDING_METHODS = this.createWeakCache();

    public static HighlightingCaches getInstance(Project project) {
        return (HighlightingCaches)ServiceManager.getService((Project)project, HighlightingCaches.class);
    }

    HighlightingCaches(@NotNull Project project) {
        project.getMessageBus().connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener(){

            public void beforePsiChanged(boolean isPhysical) {
                if (isPhysical) {
                    HighlightingCaches.this.allCaches.forEach(Map::clear);
                }
            }

            public void afterPsiChanged(boolean isPhysical) {
            }
        });
    }

    @NotNull
    private <T, V> ConcurrentMap<T, V> createWeakCache() {
        ConcurrentMap map2 = ContainerUtil.createConcurrentWeakKeySoftValueMap((int)10, (float)0.7f, (int)Runtime.getRuntime().availableProcessors(), (TObjectHashingStrategy)ContainerUtil.canonicalStrategy());
        this.allCaches.add(map2);
        return map2;
    }
}

