/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.java.stubs.index.JavaAnonymousClassBaseRefOccurenceIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSuperClassNameOccurenceIndex;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.impl.search.JavaClassInheritorsSearcher;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.impl.search.RelaxedDirectInheritorChecker;
import com.intellij.psi.impl.search.StubHierarchyInheritorSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters parameters2, @NotNull Processor<? super PsiClass> consumer) {
        PsiClass baseClass = JavaDirectInheritorsSearcher.getClassToSearch(parameters2);
        assert (parameters2.isCheckInheritance());
        Project project = PsiUtilCore.getProjectInReadAction((PsiElement)baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            SearchScope useScope = (SearchScope)ReadAction.compute(() -> ((PsiClass)baseClass).getUseScope());
            return AllClassesSearch.search((SearchScope)useScope, (Project)project).forEach(psiClass -> {
                ProgressManager.checkCanceled();
                if (psiClass.isInterface()) {
                    return consumer.process(psiClass);
                }
                PsiClass superClass = psiClass.getSuperClass();
                return superClass == null || !JavaClassInheritorsSearcher.isJavaLangObject(superClass) || consumer.process(psiClass);
            });
        }
        PsiClass[] cache = JavaDirectInheritorsSearcher.getOrCalculateDirectSubClasses(project, baseClass, parameters2);
        if (cache.length == 0) {
            return true;
        }
        SearchScope scope = parameters2.getScope();
        VirtualFile baseClassJarFile = null;
        int groupStart = 0;
        boolean sameJarClassFound = false;
        String currentFQN = null;
        boolean[] isOutOfScope = new boolean[cache.length];
        for (int i = 0; i <= cache.length; ++i) {
            String fqn;
            PsiClass subClass;
            ProgressManager.checkCanceled();
            PsiClass psiClass2 = subClass = i == cache.length ? null : cache[i];
            if (subClass instanceof PsiAnonymousClass && !parameters2.includeAnonymous()) {
                return true;
            }
            if (i != cache.length && !JavaDirectInheritorsSearcher.isInScope(scope, subClass)) {
                isOutOfScope[i] = true;
                continue;
            }
            String string = fqn = i == cache.length ? null : (String)ReadAction.compute(() -> ((PsiClass)subClass).getQualifiedName());
            if (currentFQN != null && Comparing.equal((String)fqn, (String)currentFQN)) {
                boolean fromSameJar;
                VirtualFile currentJarFile = JavaDirectInheritorsSearcher.getJarFile(subClass);
                if (baseClassJarFile == null) {
                    baseClassJarFile = JavaDirectInheritorsSearcher.getJarFile(baseClass);
                }
                if (!(fromSameJar = Comparing.equal((Object)currentJarFile, (Object)baseClassJarFile))) continue;
                if (!consumer.process((Object)subClass)) {
                    return false;
                }
                sameJarClassFound = true;
                continue;
            }
            currentFQN = fqn;
            if (!sameJarClassFound) {
                for (int g = groupStart; g < i; ++g) {
                    PsiClass subClassCandidate;
                    ProgressManager.checkCanceled();
                    if (isOutOfScope[g] || consumer.process((Object)(subClassCandidate = cache[g]))) continue;
                    return false;
                }
            }
            groupStart = i;
            sameJarClassFound = false;
        }
        return true;
    }

    private static PsiClass getClassToSearch(@NotNull DirectClassInheritorsSearch.SearchParameters parameters2) {
        return (PsiClass)ReadAction.compute(() -> (PsiClass)PsiUtil.preferCompiledElement((PsiModifierListOwner)parameters2.getClassToProcess()));
    }

    private static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiClass subClass) {
        return (Boolean)ReadAction.compute(() -> PsiSearchScopeUtil.isInScope((SearchScope)scope, (PsiElement)subClass));
    }

    @NotNull
    private static PsiClass[] getOrCalculateDirectSubClasses(@NotNull Project project, @NotNull PsiClass baseClass, @NotNull DirectClassInheritorsSearch.SearchParameters parameters2) {
        ConcurrentMap<PsiClass, PsiClass[]> map2 = HighlightingCaches.getInstance((Project)project).DIRECT_SUB_CLASSES;
        PsiClass[] cache = (PsiClass[])map2.get(baseClass);
        if (cache != null) {
            return cache;
        }
        String baseClassName = (String)ReadAction.compute(() -> ((PsiClass)baseClass).getName());
        if (StringUtil.isEmpty((String)baseClassName)) {
            return PsiClass.EMPTY_ARRAY;
        }
        cache = JavaDirectInheritorsSearcher.calculateDirectSubClasses(project, baseClass, baseClassName, parameters2);
        if (((Boolean)ReadAction.compute(() -> ((PsiClass)baseClass).isPhysical())).booleanValue()) {
            cache = (PsiClass[])ConcurrencyUtil.cacheOrGet(map2, (Object)baseClass, (Object)cache);
        }
        return cache;
    }

    private static <T> boolean processConcurrentlyIfTooMany(@NotNull Collection<T> collection, @NotNull Processor<? super T> processor) {
        int size = collection.size();
        if (size == 0) {
            return true;
        }
        if (size > 100) {
            return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<T>(collection), ProgressIndicatorProvider.getGlobalProgressIndicator(), processor);
        }
        return ContainerUtil.process(collection, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static PsiClass[] calculateDirectSubClasses(@NotNull Project project, @NotNull PsiClass baseClass, @NotNull String baseClassName, @NotNull DirectClassInheritorsSearch.SearchParameters parameters2) {
        CompilerDirectHierarchyInfo info = JavaDirectInheritorsSearcher.performSearchUsingCompilerIndices(parameters2, project);
        SearchScope useScope = info == null ? (SearchScope)ReadAction.compute(() -> ((PsiClass)baseClass).getUseScope()) : (SearchScope)ReadAction.compute(() -> baseClass.getUseScope().intersectWith((SearchScope)info.getDirtyScope()));
        DumbService dumbService = DumbService.getInstance((Project)project);
        GlobalSearchScope globalUseScope = (GlobalSearchScope)dumbService.runReadActionInSmartMode(() -> StubHierarchyInheritorSearcher.restrictScope((GlobalSearchScope)new JavaSourceFilterScope(GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)useScope, (Project)project))));
        Collection candidates = (Collection)dumbService.runReadActionInSmartMode(() -> JavaSuperClassNameOccurenceIndex.getInstance().get(baseClassName, project, globalUseScope));
        RelaxedDirectInheritorChecker checker = (RelaxedDirectInheritorChecker)dumbService.runReadActionInSmartMode(() -> new RelaxedDirectInheritorChecker(baseClass));
        HashMap classesWithFqn = new HashMap();
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(candidates, referenceList -> {
            ProgressManager.checkCanceled();
            dumbService.runReadActionInSmartMode(() -> {
                PsiClass candidate = (PsiClass)referenceList.getParent();
                if (checker.checkInheritance(candidate)) {
                    String fqn = candidate.getQualifiedName();
                    Map map2 = classesWithFqn;
                    synchronized (map2) {
                        Object value2 = classesWithFqn.get(fqn);
                        if (value2 == null) {
                            classesWithFqn.put(fqn, candidate);
                        } else if (value2 instanceof PsiClass) {
                            ArrayList<PsiClass> list = new ArrayList<PsiClass>();
                            list.add((PsiClass)value2);
                            list.add(candidate);
                            classesWithFqn.put(fqn, list);
                        } else {
                            List list = (List)value2;
                            list.add(candidate);
                        }
                    }
                }
            });
            return true;
        });
        ArrayList<Object> result = new ArrayList<Object>();
        HashMap hashMap = classesWithFqn;
        synchronized (hashMap) {
            for (Object value2 : classesWithFqn.values()) {
                if (value2 instanceof PsiClass) {
                    result.add((PsiClass)value2);
                    continue;
                }
                List list = (List)value2;
                result.addAll(list);
            }
        }
        Collection anonymousCandidates = (Collection)dumbService.runReadActionInSmartMode(() -> JavaAnonymousClassBaseRefOccurenceIndex.getInstance().get(baseClassName, project, globalUseScope));
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(anonymousCandidates, candidate -> {
            if (((Boolean)dumbService.runReadActionInSmartMode(() -> checker.checkInheritance((PsiClass)candidate))).booleanValue()) {
                List list = result;
                synchronized (list) {
                    result.add(candidate);
                }
            }
            return true;
        });
        boolean isEnum = (Boolean)ReadAction.compute(() -> ((PsiClass)baseClass).isEnum());
        if (isEnum) {
            PsiField[] fields;
            for (PsiField field : fields = (PsiField[])ReadAction.compute(() -> ((PsiClass)baseClass).getFields())) {
                ProgressManager.checkCanceled();
                if (!(field instanceof PsiEnumConstant)) continue;
                PsiEnumConstantInitializer initializingClass2 = (PsiEnumConstantInitializer)ReadAction.compute(() -> ((PsiEnumConstant)((PsiEnumConstant)field)).getInitializingClass());
                if (initializingClass2 == null) continue;
                result.add(initializingClass2);
            }
        }
        if (info != null) {
            info.getHierarchyChildren().filter(element -> element instanceof PsiClass).forEach(aClass -> result.add((PsiClass)aClass));
        }
        return result.isEmpty() ? PsiClass.EMPTY_ARRAY : result.toArray(PsiClass.EMPTY_ARRAY);
    }

    private static VirtualFile getJarFile(@NotNull PsiClass aClass) {
        return (VirtualFile)ReadAction.compute(() -> PsiUtil.getJarFile((PsiElement)aClass));
    }

    @Nullable
    private static CompilerDirectHierarchyInfo performSearchUsingCompilerIndices(@NotNull DirectClassInheritorsSearch.SearchParameters parameters2, @NotNull Project project) {
        SearchScope scope = parameters2.getScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return null;
        }
        CompilerReferenceService compilerReferenceService = CompilerReferenceService.getInstance(project);
        if (compilerReferenceService == null) {
            return null;
        }
        return compilerReferenceService.getDirectInheritors((PsiNamedElement)JavaDirectInheritorsSearcher.getClassToSearch(parameters2), (GlobalSearchScope)scope, (FileType)JavaFileType.INSTANCE);
    }
}

