/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.java.FunExprOccurrence;
import com.intellij.psi.impl.java.JavaFunctionalExpressionIndex;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionKey;
import com.intellij.psi.impl.java.stubs.index.JavaMethodParameterTypesIndex;
import com.intellij.psi.impl.search.ApproximateResolver;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFunctionalExpressionSearcher
extends QueryExecutorBase<PsiFunctionalExpression, FunctionalExpressionSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.JavaFunctionalExpressionSearcher");
    public static final int SMART_SEARCH_THRESHOLD = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQuery(@NotNull FunctionalExpressionSearch.SearchParameters p, @NotNull Processor<? super PsiFunctionalExpression> consumer) {
        List<SamDescriptor> descriptors = JavaFunctionalExpressionSearcher.calcDescriptors(p);
        Project project = PsiUtilCore.getProjectInReadAction((PsiElement)p.getElementToSearch());
        SearchScope searchScope = (SearchScope)ReadAction.compute(() -> p.getEffectiveSearchScope());
        if (searchScope instanceof GlobalSearchScope && !JavaFunctionalExpressionSearcher.performSearchUsingCompilerIndices(descriptors, (GlobalSearchScope)searchScope, project, consumer)) {
            return;
        }
        AtomicInteger exprCount = new AtomicInteger();
        AtomicInteger fileCount = new AtomicInteger();
        PsiManager manager = (PsiManager)ReadAction.compute(() -> p.getElementToSearch().getManager());
        manager.startBatchFilesProcessingMode();
        try {
            JavaFunctionalExpressionSearcher.processOffsets(descriptors, project, (PairProcessor<? super VirtualFile, ? super Set<FunExprOccurrence>>)((PairProcessor)(file, occurrences) -> {
                fileCount.incrementAndGet();
                exprCount.addAndGet(occurrences.size());
                return JavaFunctionalExpressionSearcher.processFile(consumer, descriptors, file, occurrences);
            }));
        }
        finally {
            manager.finishBatchFilesProcessingMode();
        }
        if (exprCount.get() > 0) {
            LOG.debug("Loaded " + exprCount.get() + " fun-expressions in " + fileCount.get() + " files");
        }
    }

    public static Set<VirtualFile> getFilesToSearchInPsi(PsiClass samClass) {
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        JavaFunctionalExpressionSearcher.processOffsets(JavaFunctionalExpressionSearcher.calcDescriptors(new FunctionalExpressionSearch.SearchParameters(samClass, samClass.getUseScope())), samClass.getProject(), (PairProcessor<? super VirtualFile, ? super Set<FunExprOccurrence>>)((PairProcessor)(file, offsets) -> result.add((VirtualFile)file)));
        return result;
    }

    @NotNull
    private static List<SamDescriptor> calcDescriptors(@NotNull FunctionalExpressionSearch.SearchParameters queryParameters) {
        ArrayList<SamDescriptor> descriptors = new ArrayList<SamDescriptor>();
        ReadAction.run(() -> {
            PsiClass aClass = queryParameters.getElementToSearch();
            if (!aClass.isValid() || !aClass.isInterface()) {
                return;
            }
            Project project = aClass.getProject();
            if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(aClass.getContainingFile()) || !JavaFunctionalExpressionSearcher.hasJava8Modules(project)) {
                return;
            }
            for (PsiClass samClass : JavaFunctionalExpressionSearcher.processSubInterfaces(aClass)) {
                PsiMethod saMethod;
                PsiType samType;
                if (!LambdaUtil.isFunctionalClass((PsiClass)samClass) || (samType = (saMethod = (PsiMethod)ObjectUtils.assertNotNull((Object)LambdaUtil.getFunctionalInterfaceMethod((PsiClass)samClass))).getReturnType()) == null) continue;
                SearchScope scope = samClass.getUseScope().intersectWith(queryParameters.getEffectiveSearchScope());
                descriptors.add(new SamDescriptor(samClass, saMethod, samType, GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)scope, (Project)project)));
            }
        });
        return descriptors;
    }

    @NotNull
    private static Set<VirtualFile> getLikelyFiles(List<SamDescriptor> descriptors, Collection<VirtualFile> candidateFiles, Project project) {
        GlobalSearchScope candidateFilesScope = GlobalSearchScope.filesScope((Project)project, candidateFiles);
        return JBIterable.from(descriptors).flatMap(descriptor -> ((SamDescriptor)descriptor).getMostLikelyFiles(candidateFilesScope)).toSet();
    }

    @NotNull
    private static MultiMap<VirtualFile, FunExprOccurrence> getAllOccurrences(List<? extends SamDescriptor> descriptors) {
        MultiMap result = MultiMap.createLinkedSet();
        descriptors.get((int)0).dumbService.runReadActionInSmartMode(() -> JavaFunctionalExpressionSearcher.processIndexValues(descriptors, null, (FileBasedIndex.ValueProcessor<Map<Integer, FunExprOccurrence>>)((FileBasedIndex.ValueProcessor)(file, infos) -> {
            result.putValues((Object)file, infos.values());
            return true;
        })));
        LOG.debug("Found " + result.values().size() + " fun-expressions in " + result.keySet().size() + " files");
        return result;
    }

    private static void processIndexValues(List<? extends SamDescriptor> descriptors, VirtualFile inFile, FileBasedIndex.ValueProcessor<Map<Integer, FunExprOccurrence>> processor) {
        for (SamDescriptor samDescriptor : descriptors) {
            JavaSourceFilterScope scope = new JavaSourceFilterScope(samDescriptor.effectiveUseScope);
            for (FunctionalExpressionKey key2 : samDescriptor.keys) {
                FileBasedIndex.getInstance().processValues(JavaFunctionalExpressionIndex.INDEX_ID, (Object)key2, inFile, processor, (GlobalSearchScope)scope);
            }
        }
    }

    private static void processOffsets(List<SamDescriptor> descriptors, Project project, PairProcessor<? super VirtualFile, ? super Set<FunExprOccurrence>> processor) {
        if (descriptors.isEmpty()) {
            return;
        }
        List samClasses = ContainerUtil.map(descriptors, d -> d.samClass);
        MultiMap<VirtualFile, FunExprOccurrence> allCandidates = JavaFunctionalExpressionSearcher.getAllOccurrences(descriptors);
        if (allCandidates.isEmpty()) {
            return;
        }
        for (VirtualFile vFile : JavaFunctionalExpressionSearcher.putLikelyFilesFirst(descriptors, allCandidates.keySet(), project)) {
            Set<FunExprOccurrence> toLoad = JavaFunctionalExpressionSearcher.filterInapplicable(samClasses, vFile, allCandidates.get((Object)vFile), project);
            if (toLoad.isEmpty()) continue;
            LOG.trace("To load " + vFile.getPath() + " with values: " + toLoad);
            if (processor.process((Object)vFile, toLoad)) continue;
            return;
        }
    }

    @NotNull
    private static Set<VirtualFile> putLikelyFilesFirst(List<SamDescriptor> descriptors, Set<VirtualFile> allFiles, Project project) {
        LinkedHashSet<VirtualFile> orderedFiles = new LinkedHashSet<VirtualFile>(allFiles.size());
        orderedFiles.addAll(JavaFunctionalExpressionSearcher.getLikelyFiles(descriptors, allFiles, project));
        orderedFiles.addAll(allFiles);
        return orderedFiles;
    }

    @NotNull
    private static Set<FunExprOccurrence> filterInapplicable(List<? extends PsiClass> samClasses, VirtualFile vFile, Collection<? extends FunExprOccurrence> occurrences, Project project) {
        return (Set)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> new HashSet(ContainerUtil.filter((Collection)occurrences, it -> it.canHaveType(samClasses, vFile))));
    }

    private static boolean processFile(@NotNull Processor<? super PsiFunctionalExpression> consumer, List<? extends SamDescriptor> descriptors, VirtualFile vFile, Set<FunExprOccurrence> occurrences) {
        return (Boolean)descriptors.get((int)0).dumbService.runReadActionInSmartMode(() -> {
            PsiFile file = ((SamDescriptor)descriptors.get((int)0)).samClass.getManager().findFile(vFile);
            if (!(file instanceof PsiJavaFile)) {
                LOG.error("Non-java file " + file + "; " + vFile);
                return true;
            }
            List<Integer> offsets = JavaFunctionalExpressionSearcher.getOccurrenceOffsets(descriptors, vFile, occurrences);
            for (Integer offset : offsets) {
                PsiFunctionalExpression expression2 = (PsiFunctionalExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiFunctionalExpression.class, (boolean)false);
                if (expression2 == null || expression2.getTextRange().getStartOffset() != offset.intValue()) {
                    LOG.error("Fun expression not found in " + file + " at " + offset);
                    continue;
                }
                if (!JavaFunctionalExpressionSearcher.hasType(descriptors, expression2) || consumer.process((Object)expression2)) continue;
                return false;
            }
            return true;
        });
    }

    private static List<Integer> getOccurrenceOffsets(List<? extends SamDescriptor> descriptors, VirtualFile vFile, Set<FunExprOccurrence> occurrences) {
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        JavaFunctionalExpressionSearcher.processIndexValues(descriptors, vFile, (FileBasedIndex.ValueProcessor<Map<Integer, FunExprOccurrence>>)((FileBasedIndex.ValueProcessor)(__, infos) -> {
            for (Map.Entry entry : infos.entrySet()) {
                if (!occurrences.contains(entry.getValue())) continue;
                offsets.add((Integer)entry.getKey());
            }
            return true;
        }));
        return offsets;
    }

    private static boolean hasType(List<? extends SamDescriptor> descriptors, PsiFunctionalExpression expression2) {
        if (!JavaFunctionalExpressionSearcher.canHaveType(expression2, ContainerUtil.map(descriptors, d -> d.samClass))) {
            return false;
        }
        PsiClass actualClass = LambdaUtil.resolveFunctionalInterfaceClass((PsiFunctionalExpression)expression2);
        return ContainerUtil.exists(descriptors, d -> InheritanceUtil.isInheritorOrSelf((PsiClass)actualClass, (PsiClass)d.samClass, (boolean)true));
    }

    private static boolean canHaveType(PsiFunctionalExpression expression2, List<? extends PsiClass> samClasses) {
        PsiElement parent = expression2.getParent();
        if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiMethodCallExpression) {
            PsiExpression[] args = ((PsiExpressionList)parent).getExpressions();
            int argIndex = Arrays.asList(args).indexOf(expression2);
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)parent.getParent()).getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            String methodName = methodExpression.getReferenceName();
            if (qualifier != null && methodName != null && argIndex >= 0) {
                Set<PsiClass> approximateTypes = ApproximateResolver.getPossibleTypes(qualifier, 10);
                List<PsiMethod> methods = approximateTypes == null ? null : ApproximateResolver.getPossibleMethods(approximateTypes, methodName, args.length);
                return methods == null || ContainerUtil.exists(methods, m -> FunExprOccurrence.hasCompatibleParameter(m, argIndex, samClasses));
            }
        }
        return true;
    }

    private static boolean hasJava8Modules(Project project) {
        boolean projectLevelIsHigh = PsiUtil.getLanguageLevel((Project)project).isAtLeast(LanguageLevel.JDK_1_8);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            LanguageLevel level;
            LanguageLevelModuleExtension extension = (LanguageLevelModuleExtension)ModuleRootManager.getInstance((Module)module).getModuleExtension(LanguageLevelModuleExtension.class);
            if (extension == null || ((level = extension.getLanguageLevel()) != null || !projectLevelIsHigh) && (level == null || !level.isAtLeast(LanguageLevel.JDK_1_8))) continue;
            return true;
        }
        return false;
    }

    private static Set<PsiClass> processSubInterfaces(PsiClass base) {
        final HashSet<PsiClass> result = new HashSet<PsiClass>();
        new Object(){

            void visit(PsiClass c) {
                if (!result.add(c)) {
                    return;
                }
                DirectClassInheritorsSearch.search((PsiClass)c).forEach(candidate -> {
                    if (candidate.isInterface()) {
                        this.visit((PsiClass)candidate);
                    }
                    return true;
                });
            }
        }.visit(base);
        return result;
    }

    private static boolean performSearchUsingCompilerIndices(@NotNull List<? extends SamDescriptor> descriptors, @NotNull GlobalSearchScope searchScope, @NotNull Project project, @NotNull Processor<? super PsiFunctionalExpression> consumer) {
        CompilerReferenceService compilerReferenceService = CompilerReferenceService.getInstance(project);
        if (compilerReferenceService == null) {
            return true;
        }
        for (SamDescriptor samDescriptor : descriptors) {
            if (JavaFunctionalExpressionSearcher.processFunctionalExpressions(JavaFunctionalExpressionSearcher.performSearchUsingCompilerIndices(samDescriptor, searchScope, compilerReferenceService), samDescriptor, consumer)) continue;
            return false;
        }
        return true;
    }

    private static CompilerDirectHierarchyInfo performSearchUsingCompilerIndices(@NotNull SamDescriptor descriptor, @NotNull GlobalSearchScope searchScope, @NotNull CompilerReferenceService service) {
        return service.getFunExpressions((PsiNamedElement)descriptor.samClass, searchScope, (FileType)JavaFileType.INSTANCE);
    }

    private static boolean processFunctionalExpressions(@Nullable CompilerDirectHierarchyInfo funExprInfo, @NotNull SamDescriptor descriptor, @NotNull Processor<? super PsiFunctionalExpression> consumer) {
        if (funExprInfo != null) {
            if (!ContainerUtil.process(funExprInfo.getHierarchyChildren().iterator(), fe -> consumer.process((Object)((PsiFunctionalExpression)fe)))) {
                return false;
            }
            GlobalSearchScope dirtyScope = funExprInfo.getDirtyScope();
            descriptor.effectiveUseScope = descriptor.effectiveUseScope.intersectWith(dirtyScope);
        }
        return true;
    }

    private static class SamDescriptor {
        final PsiClass samClass;
        final int samParamCount;
        final boolean booleanCompatible;
        final boolean isVoid;
        final DumbService dumbService;
        final List<FunctionalExpressionKey> keys;
        GlobalSearchScope effectiveUseScope;

        SamDescriptor(PsiClass samClass, PsiMethod samMethod, PsiType samType, GlobalSearchScope useScope) {
            this.samClass = samClass;
            this.effectiveUseScope = useScope;
            this.samParamCount = samMethod.getParameterList().getParametersCount();
            this.booleanCompatible = FunctionalExpressionKey.isBooleanCompatible(samType);
            this.isVoid = PsiType.VOID.equals((Object)samType);
            this.dumbService = DumbService.getInstance((Project)samClass.getProject());
            this.keys = this.generateKeys();
        }

        private List<FunctionalExpressionKey> generateKeys() {
            String name;
            String string = name = this.samClass.isValid() ? this.samClass.getName() : null;
            if (name == null) {
                return Collections.emptyList();
            }
            ArrayList<FunctionalExpressionKey> result = new ArrayList<FunctionalExpressionKey>();
            for (String lambdaType : new String[]{(String)ObjectUtils.assertNotNull((Object)name), ""}) {
                for (int lambdaParamCount : new int[]{-1, this.samParamCount}) {
                    result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.UNKNOWN, lambdaType));
                    if (this.isVoid) {
                        result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.VOID, lambdaType));
                        continue;
                    }
                    if (this.booleanCompatible) {
                        result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.BOOLEAN, lambdaType));
                    }
                    result.add(new FunctionalExpressionKey(lambdaParamCount, FunctionalExpressionKey.CoarseType.NON_VOID, lambdaType));
                }
            }
            return result;
        }

        @NotNull
        private Set<VirtualFile> getMostLikelyFiles(GlobalSearchScope searchScope) {
            LinkedHashSet files = ContainerUtil.newLinkedHashSet();
            this.dumbService.runReadActionInSmartMode(() -> {
                if (!this.samClass.isValid()) {
                    return;
                }
                String className = this.samClass.getName();
                Project project = this.samClass.getProject();
                if (className == null) {
                    return;
                }
                LinkedHashSet likelyNames = ContainerUtil.newLinkedHashSet((Object[])new String[]{className});
                StubIndex.getInstance().processElements(JavaMethodParameterTypesIndex.getInstance().getKey(), (Object)className, project, this.effectiveUseScope, PsiMethod.class, method -> {
                    ProgressManager.checkCanceled();
                    likelyNames.add(method.getName());
                    return true;
                });
                PsiSearchHelperImpl helper = (PsiSearchHelperImpl)PsiSearchHelper.getInstance((Project)project);
                Processor processor = Processors.cancelableCollectProcessor((Collection)files);
                for (String word : likelyNames) {
                    helper.processFilesWithText(searchScope, (short)1, true, word, processor);
                }
            });
            return files;
        }
    }
}

