/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaOverridingMethodsSearcher
implements QueryExecutor<PsiMethod, OverridingMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull OverridingMethodsSearch.SearchParameters parameters2, @NotNull Processor<? super PsiMethod> consumer) {
        VirtualFile[] files;
        PsiMethod method = parameters2.getMethod();
        Project project = (Project)ReadAction.compute(() -> ((PsiMethod)method).getProject());
        SearchScope searchScope = parameters2.getScope();
        if (searchScope instanceof LocalSearchScope && JavaOverridingMethodsSearcher.isJavaOnlyScope(files = ((LocalSearchScope)searchScope).getVirtualFiles())) {
            return JavaOverridingMethodsSearcher.processLocalScope((LocalSearchScope)searchScope, method, project, consumer);
        }
        Iterable<PsiMethod> cached = HighlightingCaches.getInstance((Project)project).OVERRIDING_METHODS.get(method);
        if (cached == null) {
            cached = JavaOverridingMethodsSearcher.compute(method, project);
            if (((Boolean)ReadAction.compute(() -> ((PsiMethod)method).isPhysical())).booleanValue()) {
                HighlightingCaches.getInstance((Project)project).OVERRIDING_METHODS.put(method, cached);
            }
        }
        for (PsiMethod subMethod : cached) {
            ProgressManager.checkCanceled();
            if (!((Boolean)ReadAction.compute(() -> PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)subMethod))).booleanValue() || consumer.process((Object)subMethod) && parameters2.isCheckDeep()) continue;
            return false;
        }
        return true;
    }

    static boolean isJavaOnlyScope(@NotNull VirtualFile[] files) {
        return Arrays.stream(files).allMatch(file -> file.getFileType() == JavaFileType.INSTANCE);
    }

    private static boolean processLocalScope(@NotNull LocalSearchScope searchScope, final @NotNull PsiMethod method, final @NotNull Project project, final @NotNull Processor<? super PsiMethod> consumer) {
        VirtualFile[] virtualFiles = searchScope.getVirtualFiles();
        final PsiClass methodContainingClass = (PsiClass)ReadAction.compute(() -> ((PsiMethod)method).getContainingClass());
        if (methodContainingClass == null) {
            return true;
        }
        final boolean[] success = new boolean[]{true};
        for (final VirtualFile virtualFile : virtualFiles) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (psiFile != null) {
                        psiFile.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                            public void visitClass(PsiClass candidate) {
                                PsiMethod overridingMethod;
                                ProgressManager.checkCanceled();
                                PsiMethod psiMethod = overridingMethod = candidate.isInheritor(methodContainingClass, true) ? JavaOverridingMethodsSearcher.findOverridingMethod(candidate, method, methodContainingClass) : null;
                                if (overridingMethod != null && !consumer.process((Object)overridingMethod)) {
                                    success[0] = false;
                                    this.stopWalking();
                                } else {
                                    super.visitClass(candidate);
                                }
                            }
                        });
                    }
                }
            });
        }
        return success[0];
    }

    @NotNull
    private static Iterable<PsiMethod> compute(@NotNull PsiMethod method, @NotNull Project project) {
        PsiClass containingClass = (PsiClass)ReadAction.compute(() -> ((PsiMethod)method).getContainingClass());
        assert (containingClass != null);
        LinkedHashSet<PsiMethod> result = new LinkedHashSet<PsiMethod>();
        Processor inheritorsProcessor = inheritor -> {
            PsiMethod found = (PsiMethod)ReadAction.compute(() -> JavaOverridingMethodsSearcher.findOverridingMethod(inheritor, method, containingClass));
            if (found != null) {
                result.add(found);
            }
            return true;
        };
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        boolean success = ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)allScope, (boolean)true).forEach(inheritorsProcessor);
        assert (success);
        return result;
    }

    @Nullable
    public static PsiMethod findOverridingMethod(@NotNull PsiClass inheritor, @NotNull PsiMethod method, @NotNull PsiClass methodContainingClass) {
        MethodSignature signature;
        PsiMethod derived;
        PsiClass superClass;
        PsiMethod found;
        String name = method.getName();
        if (inheritor.findMethodsByName(name, false).length > 0 && (found = MethodSignatureUtil.findMethodBySuperSignature((PsiClass)inheritor, (MethodSignature)JavaOverridingMethodsSearcher.getSuperSignature(inheritor, methodContainingClass, method), (boolean)false)) != null && JavaOverridingMethodsSearcher.isAcceptable(found, inheritor, method, methodContainingClass)) {
            return found;
        }
        if (methodContainingClass.isInterface() && !inheritor.isInterface() && (superClass = inheritor.getSuperClass()) != null && !superClass.isInheritor(methodContainingClass, true) && superClass.findMethodsByName(name, true).length > 0 && (derived = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived((PsiClass)inheritor, (PsiClass)superClass, (MethodSignature)(signature = JavaOverridingMethodsSearcher.getSuperSignature(inheritor, methodContainingClass, method)), (boolean)true)) != null && JavaOverridingMethodsSearcher.isAcceptable(derived, inheritor, method, methodContainingClass)) {
            return derived;
        }
        return null;
    }

    @NotNull
    private static MethodSignature getSuperSignature(PsiClass inheritor, @NotNull PsiClass parentClass, PsiMethod method) {
        PsiSubstitutor substitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)parentClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return method.getSignature(substitutor != null ? substitutor : PsiSubstitutor.EMPTY);
    }

    private static boolean isAcceptable(@NotNull PsiMethod found, @NotNull PsiClass foundContainingClass, @NotNull PsiMethod method, @NotNull PsiClass methodContainingClass) {
        return !found.hasModifierProperty("static") && (!method.hasModifierProperty("packageLocal") || JavaPsiFacade.getInstance((Project)found.getProject()).arePackagesTheSame((PsiElement)methodContainingClass, (PsiElement)foundContainingClass));
    }
}

