/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MethodDeepestSuperSearcher
implements QueryExecutor<PsiMethod, PsiMethod> {
    public boolean execute(@NotNull PsiMethod method, @NotNull Processor<? super PsiMethod> consumer) {
        return MethodDeepestSuperSearcher.processDeepestSuperMethods(method, consumer);
    }

    public static boolean processDeepestSuperMethods(@NotNull PsiMethod method, @NotNull Processor<? super PsiMethod> consumer) {
        THashSet methods = new THashSet();
        methods.add(method);
        return MethodDeepestSuperSearcher.findDeepestSuperOrSelfSignature(method, (Set<? super PsiMethod>)methods, null, consumer);
    }

    private static boolean findDeepestSuperOrSelfSignature(@NotNull PsiMethod method, @NotNull Set<? super PsiMethod> set, Set<? super PsiMethod> guard, @NotNull Processor<? super PsiMethod> processor) {
        if (guard != null && !guard.add((PsiMethod)method)) {
            return true;
        }
        PsiMethod[] supers = (PsiMethod[])ReadAction.compute(() -> method.findSuperMethods());
        if (supers.length == 0 && set.add((PsiMethod)method) && !processor.process((Object)method)) {
            return false;
        }
        for (PsiMethod superMethod : supers) {
            if (guard == null) {
                guard = new THashSet();
                guard.add(method);
            }
            if (MethodDeepestSuperSearcher.findDeepestSuperOrSelfSignature(superMethod, set, (Set<? super PsiMethod>)guard, processor)) continue;
            return false;
        }
        return true;
    }
}

