/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassInnerStuffCache {
    private final PsiExtensibleClass myClass;
    private final SimpleModificationTracker myTracker = new SimpleModificationTracker();

    public ClassInnerStuffCache(@NotNull PsiExtensibleClass aClass) {
        this.myClass = aClass;
    }

    @NotNull
    public PsiMethod[] getConstructors() {
        return (PsiMethod[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(PsiImplUtil.getConstructors(this.myClass))));
    }

    @NotNull
    public PsiField[] getFields() {
        return (PsiField[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.calcFields())));
    }

    @NotNull
    public PsiMethod[] getMethods() {
        return (PsiMethod[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.calcMethods())));
    }

    @NotNull
    public PsiClass[] getInnerClasses() {
        return (PsiClass[])ClassInnerStuffCache.copy((Object[])CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.calcInnerClasses())));
    }

    @Nullable
    public PsiField findFieldByName(String name, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findFieldByName(this.myClass, name, true);
        }
        return (PsiField)((Map)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.getFieldsMap()))).get(name);
    }

    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findMethodsByName(this.myClass, name, true);
        }
        return (PsiMethod[])ClassInnerStuffCache.copy((Object[])ObjectUtils.notNull(((Map)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.getMethodsMap()))).get(name), (Object)PsiMethod.EMPTY_ARRAY));
    }

    @Nullable
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findInnerByName(this.myClass, name, true);
        }
        return (PsiClass)((Map)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.getInnerClassesMap()))).get(name);
    }

    @Nullable
    public PsiMethod getValuesMethod() {
        return this.myClass.isEnum() && this.myClass.getName() != null ? (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.makeValuesMethod())) : null;
    }

    @Nullable
    public PsiMethod getValueOfMethod() {
        return this.myClass.isEnum() && this.myClass.getName() != null ? (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)this.myClass, () -> this.makeResult(this.makeValueOfMethod())) : null;
    }

    private static <T> T[] copy(T[] value2) {
        return value2.length == 0 ? value2 : (Object[])value2.clone();
    }

    private <T> CachedValueProvider.Result<T> makeResult(T value2) {
        return CachedValueProvider.Result.create(value2, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, this.myTracker});
    }

    @NotNull
    private PsiField[] calcFields() {
        List<PsiField> own = this.myClass.getOwnFields();
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiField.class);
        return (PsiField[])ArrayUtil.mergeCollections(own, (Collection)ext, (ArrayFactory)PsiField.ARRAY_FACTORY);
    }

    @NotNull
    private PsiMethod[] calcMethods() {
        List<PsiMethod> own = this.myClass.getOwnMethods();
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiMethod.class);
        return (PsiMethod[])ArrayUtil.mergeCollections(own, (Collection)ext, (ArrayFactory)PsiMethod.ARRAY_FACTORY);
    }

    @NotNull
    private PsiClass[] calcInnerClasses() {
        List<PsiClass> own = this.myClass.getOwnInnerClasses();
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiClass.class);
        return (PsiClass[])ArrayUtil.mergeCollections(own, (Collection)ext, (ArrayFactory)PsiClass.ARRAY_FACTORY);
    }

    @NotNull
    private Map<String, PsiField> getFieldsMap() {
        PsiField[] fields = this.getFields();
        if (fields.length == 0) {
            return Collections.emptyMap();
        }
        THashMap cachedFields = new THashMap();
        for (PsiField field : fields) {
            String name = field.getName();
            if (cachedFields.containsKey(name)) continue;
            cachedFields.put(name, field);
        }
        return cachedFields;
    }

    @NotNull
    private Map<String, PsiMethod[]> getMethodsMap() {
        PsiMethod[] methods = this.getMethods();
        if (methods.length == 0) {
            return Collections.emptyMap();
        }
        HashMap collectedMethods = ContainerUtil.newHashMap();
        for (PsiMethod method : methods) {
            List list = (List)collectedMethods.get(method.getName());
            if (list == null) {
                list = ContainerUtil.newSmartList();
                collectedMethods.put(method.getName(), list);
            }
            list.add(method);
        }
        THashMap cachedMethods = ContainerUtil.newTroveMap();
        for (Map.Entry entry : collectedMethods.entrySet()) {
            List list = (List)entry.getValue();
            cachedMethods.put(entry.getKey(), list.toArray(PsiMethod.EMPTY_ARRAY));
        }
        return cachedMethods;
    }

    @NotNull
    private Map<String, PsiClass> getInnerClassesMap() {
        PsiClass[] classes2 = this.getInnerClasses();
        if (classes2.length == 0) {
            return Collections.emptyMap();
        }
        THashMap cachedInners = new THashMap();
        for (PsiClass psiClass : classes2) {
            String name = psiClass.getName();
            if (name == null) {
                Logger.getInstance(ClassInnerStuffCache.class).error((Object)psiClass);
                continue;
            }
            if (psiClass instanceof ExternallyDefinedPsiElement && cachedInners.containsKey(name)) continue;
            cachedInners.put(name, psiClass);
        }
        return cachedInners;
    }

    private PsiMethod makeValuesMethod() {
        return this.getSyntheticMethod("public static " + this.myClass.getName() + "[] values() { }");
    }

    private PsiMethod makeValueOfMethod() {
        return this.getSyntheticMethod("public static " + this.myClass.getName() + " valueOf(java.lang.String name) throws java.lang.IllegalArgumentException { }");
    }

    private PsiMethod getSyntheticMethod(String text2) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myClass.getProject());
        PsiMethod method = factory.createMethodFromText(text2, (PsiElement)this.myClass);
        return new LightMethod(this.myClass.getManager(), method, this.myClass){

            public int getTextOffset() {
                return ClassInnerStuffCache.this.myClass.getTextOffset();
            }
        };
    }

    public void dropCaches() {
        this.myTracker.incModificationCount();
    }
}

