/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileLocalResolver {
    private final LighterAST myTree;

    public FileLocalResolver(@NotNull LighterAST tree) {
        this.myTree = tree;
    }

    @NotNull
    public LighterAST getLightTree() {
        return this.myTree;
    }

    @NotNull
    public LightResolveResult resolveLocally(@NotNull LighterASTNode ref) {
        String refName = JavaLightTreeUtil.getNameIdentifierText(this.myTree, ref);
        if (refName == null) {
            return LightResolveResult.UNKNOWN;
        }
        if (!this.canResolveToLocalVariable(this.myTree, ref)) {
            return LightResolveResult.NON_LOCAL;
        }
        boolean passedClass = false;
        LighterASTNode lastParent = ref;
        while (true) {
            ProgressManager.checkCanceled();
            LighterASTNode scope = this.myTree.getParent(lastParent);
            if (scope == null) {
                return LightResolveResult.NON_LOCAL;
            }
            for (LighterASTNode var : this.getDeclarations(scope, lastParent)) {
                if (!refName.equals(JavaLightTreeUtil.getNameIdentifierText(this.myTree, var))) continue;
                if (passedClass) {
                    return var.getTokenType() == JavaElementType.FIELD ? LightResolveResult.NON_LOCAL : LightResolveResult.UNKNOWN;
                }
                return LightResolveResult.resolved(var);
            }
            lastParent = scope;
            passedClass |= scope.getTokenType() == JavaElementType.CLASS || scope.getTokenType() == JavaElementType.ANONYMOUS_CLASS;
        }
    }

    private boolean canResolveToLocalVariable(@NotNull LighterAST tree, @NotNull LighterASTNode ref) {
        LighterASTNode parent = tree.getParent(ref);
        return parent != null && parent.getTokenType() != JavaElementType.METHOD_CALL_EXPRESSION && !this.hasQualifier(ref);
    }

    private boolean hasQualifier(@NotNull LighterASTNode ref) {
        return LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)ref, (TokenSet)ElementType.EXPRESSION_BIT_SET) != null;
    }

    @NotNull
    private Iterable<LighterASTNode> getDeclarations(LighterASTNode scope, @Nullable LighterASTNode lastParent) {
        IElementType type2 = scope.getTokenType();
        if (type2 == JavaElementType.CODE_BLOCK) {
            return this.walkChildrenScopes(FileLocalResolver.before(LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.DECLARATION_STATEMENT), lastParent));
        }
        if (type2 == JavaElementType.DECLARATION_STATEMENT) {
            return FileLocalResolver.before(LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.LOCAL_VARIABLE), lastParent);
        }
        if (type2 == JavaElementType.FOR_STATEMENT) {
            return this.walkChildrenScopes(FileLocalResolver.before(LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)scope, (TokenSet)ElementType.JAVA_STATEMENT_BIT_SET), lastParent));
        }
        if (type2 == JavaElementType.FOREACH_STATEMENT || type2 == JavaElementType.CATCH_SECTION) {
            return JBIterable.of((Object)LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.PARAMETER));
        }
        if (type2 == JavaElementType.TRY_STATEMENT) {
            return this.walkChildrenScopes(FileLocalResolver.before(LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.RESOURCE_LIST), lastParent));
        }
        if (type2 == JavaElementType.RESOURCE_LIST) {
            return FileLocalResolver.before(LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.RESOURCE_VARIABLE), lastParent);
        }
        if (type2 == JavaElementType.CLASS) {
            return LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.FIELD);
        }
        if (type2 == JavaElementType.LAMBDA_EXPRESSION || type2 == JavaElementType.METHOD) {
            LighterASTNode paramList = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.PARAMETER_LIST);
            return paramList == null ? ContainerUtil.emptyList() : LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)paramList, (IElementType)JavaElementType.PARAMETER);
        }
        return Collections.emptyList();
    }

    @NotNull
    private JBIterable<LighterASTNode> walkChildrenScopes(JBIterable<LighterASTNode> children) {
        return children.flatMap(child -> this.getDeclarations((LighterASTNode)child, null));
    }

    @NotNull
    private static JBIterable<LighterASTNode> before(List<LighterASTNode> children, @Nullable LighterASTNode lastParent) {
        return JBIterable.from(children).filter(node -> lastParent == null || node.getStartOffset() < lastParent.getStartOffset());
    }

    @Nullable
    public String getShortClassTypeName(@NotNull LighterASTNode var) {
        LighterASTNode typeRef = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)var, (IElementType)JavaElementType.TYPE), (IElementType)JavaElementType.JAVA_CODE_REFERENCE);
        String refName = JavaLightTreeUtil.getNameIdentifierText(this.myTree, typeRef);
        if (refName == null) {
            return null;
        }
        if (LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)typeRef, (IElementType)JavaElementType.JAVA_CODE_REFERENCE) != null) {
            return refName;
        }
        if (this.isTypeParameter(refName, var)) {
            return null;
        }
        return refName;
    }

    private boolean isTypeParameter(String name, LighterASTNode place) {
        LighterASTNode scope = place;
        while (scope != null) {
            if (scope.getTokenType() == JavaElementType.CLASS || scope.getTokenType() == JavaElementType.METHOD) {
                if (this.hasOwnTypeParameter(name, scope)) {
                    return true;
                }
                if (this.isStatic(scope)) break;
            }
            scope = this.myTree.getParent(scope);
        }
        return false;
    }

    private boolean hasOwnTypeParameter(String name, LighterASTNode member) {
        LighterASTNode typeParams = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)member, (IElementType)JavaElementType.TYPE_PARAMETER_LIST);
        if (typeParams != null) {
            for (LighterASTNode param : LightTreeUtil.getChildrenOfType((LighterAST)this.myTree, (LighterASTNode)typeParams, (IElementType)JavaElementType.TYPE_PARAMETER)) {
                if (!name.equals(JavaLightTreeUtil.getNameIdentifierText(this.myTree, param))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStatic(LighterASTNode scope) {
        LighterASTNode modList = LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)scope, (IElementType)JavaElementType.MODIFIER_LIST);
        return modList != null && LightTreeUtil.firstChildOfType((LighterAST)this.myTree, (LighterASTNode)modList, (IElementType)JavaTokenType.STATIC_KEYWORD) != null;
    }

    public static class LightResolveResult {
        public static final LightResolveResult UNKNOWN = new LightResolveResult();
        public static final LightResolveResult NON_LOCAL = new LightResolveResult();

        @NotNull
        static LightResolveResult resolved(final @NotNull LighterASTNode target) {
            return new LightResolveResult(){

                @Override
                @Nullable
                public LighterASTNode getTarget() {
                    return target;
                }
            };
        }

        @Nullable
        public LighterASTNode getTarget() {
            return null;
        }
    }
}

