/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.stubs.LightStubBuilder;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JavaLightStubBuilder
extends LightStubBuilder {
    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file, @NotNull LighterAST tree) {
        LighterASTNode ref;
        if (!(file instanceof PsiJavaFile)) {
            return super.createStubForFile(file, tree);
        }
        String refText = "";
        LighterASTNode pkg = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)tree.getRoot(), (IElementType)JavaElementType.PACKAGE_STATEMENT);
        if (pkg != null && (ref = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)pkg, (IElementType)JavaElementType.JAVA_CODE_REFERENCE)) != null) {
            refText = JavaSourceUtil.getReferenceText(tree, ref);
        }
        return new PsiJavaFileStubImpl((PsiJavaFile)file, refText, null, false);
    }

    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        IElementType nodeType;
        IElementType parentType = parent.getElementType();
        if (JavaLightStubBuilder.checkByTypes(parentType, nodeType = node.getElementType())) {
            return true;
        }
        if (nodeType == JavaElementType.CODE_BLOCK) {
            CodeBlockVisitor visitor = new CodeBlockVisitor();
            ((TreeElement)node).acceptTree((TreeElementVisitor)visitor);
            return visitor.result;
        }
        return false;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull LighterAST tree, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        return JavaLightStubBuilder.checkByTypes(parent.getTokenType(), node.getTokenType()) || JavaLightStubBuilder.isCodeBlockWithoutStubs(node);
    }

    public static boolean isCodeBlockWithoutStubs(@NotNull LighterASTNode node) {
        if (node.getTokenType() == JavaElementType.CODE_BLOCK && node instanceof LighterLazyParseableNode) {
            CodeBlockVisitor visitor = new CodeBlockVisitor();
            ((LighterLazyParseableNode)node).accept((LighterLazyParseableNode.Visitor)visitor);
            return visitor.result;
        }
        return false;
    }

    private static boolean checkByTypes(IElementType parentType, IElementType nodeType) {
        if (ElementType.IMPORT_STATEMENT_BASE_BIT_SET.contains(parentType)) {
            return true;
        }
        if (nodeType == JavaElementType.RECEIVER_PARAMETER) {
            return true;
        }
        if (nodeType == JavaElementType.PARAMETER && parentType != JavaElementType.PARAMETER_LIST) {
            return true;
        }
        if (nodeType == JavaElementType.PARAMETER_LIST && parentType == JavaElementType.LAMBDA_EXPRESSION) {
            return true;
        }
        return nodeType == JavaDocElementType.DOC_COMMENT;
    }

    private static class CodeBlockVisitor
    extends RecursiveTreeElementWalkingVisitor
    implements LighterLazyParseableNode.Visitor {
        private static final TokenSet BLOCK_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.CLASS, JavaElementType.ANONYMOUS_CLASS, JavaTokenType.ARROW, JavaTokenType.DOUBLE_COLON, JavaTokenType.AT});
        private boolean result = true;
        private IElementType preLast;
        private IElementType last;
        private boolean seenNew;
        private boolean seenLParen;
        private boolean seenModifier;

        private CodeBlockVisitor() {
        }

        protected void visitNode(TreeElement element) {
            if (BLOCK_ELEMENTS.contains(element.getElementType())) {
                this.result = false;
                this.stopWalking();
                return;
            }
            super.visitNode(element);
        }

        public boolean visit(IElementType type2) {
            if (ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(type2)) {
                return true;
            }
            if (type2 == JavaTokenType.AT || type2 == JavaTokenType.ARROW || type2 == JavaTokenType.DOUBLE_COLON) {
                this.result = false;
                return false;
            }
            if (type2 == JavaTokenType.NEW_KEYWORD) {
                this.seenNew = true;
            } else if (this.seenNew && type2 == JavaTokenType.SEMICOLON) {
                this.seenNew = false;
                this.seenLParen = false;
            } else {
                if (this.seenNew && type2 == JavaTokenType.LBRACE && this.seenLParen) {
                    this.result = false;
                    return false;
                }
                if (this.seenNew && type2 == JavaTokenType.LPARENTH) {
                    this.seenLParen = true;
                } else if (ElementType.MODIFIER_BIT_SET.contains(type2)) {
                    this.seenModifier = true;
                } else if (type2 == JavaTokenType.CLASS_KEYWORD && (this.last != JavaTokenType.DOT || this.preLast != JavaTokenType.IDENTIFIER || this.seenModifier) || type2 == JavaTokenType.ENUM_KEYWORD || type2 == JavaTokenType.INTERFACE_KEYWORD) {
                    this.result = false;
                    return false;
                }
            }
            this.preLast = this.last;
            this.last = type2;
            return true;
        }
    }
}

