/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLightTreeUtil {
    @Nullable
    @Contract(value="_,null->null")
    public static List<LighterASTNode> getArgList(@NotNull LighterAST tree, @Nullable LighterASTNode call) {
        LighterASTNode anonClass = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)call, (IElementType)JavaElementType.ANONYMOUS_CLASS);
        LighterASTNode exprList = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)(anonClass != null ? anonClass : call), (IElementType)JavaElementType.EXPRESSION_LIST);
        return exprList == null ? null : JavaLightTreeUtil.getExpressionChildren(tree, exprList);
    }

    @Nullable
    @Contract(value="_,null->null")
    public static String getNameIdentifierText(@NotNull LighterAST tree, @Nullable LighterASTNode idOwner) {
        LighterASTNode id = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)idOwner, (IElementType)JavaTokenType.IDENTIFIER);
        return id != null ? RecordUtil.intern(tree.getCharTable(), id) : null;
    }

    @NotNull
    public static List<LighterASTNode> getExpressionChildren(@NotNull LighterAST tree, @NotNull LighterASTNode node) {
        return LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)node, (TokenSet)ElementType.EXPRESSION_BIT_SET);
    }

    @Nullable
    public static LighterASTNode findExpressionChild(@NotNull LighterAST tree, @Nullable LighterASTNode node) {
        return LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)node, (TokenSet)ElementType.EXPRESSION_BIT_SET);
    }

    @Nullable
    public static LighterASTNode skipParenthesesCastsDown(@NotNull LighterAST tree, @Nullable LighterASTNode node) {
        while (node != null && (node.getTokenType() == JavaElementType.PARENTH_EXPRESSION || node.getTokenType() == JavaElementType.TYPE_CAST_EXPRESSION)) {
            node = JavaLightTreeUtil.findExpressionChild(tree, node);
        }
        return node;
    }

    @Nullable
    public static LighterASTNode skipParenthesesDown(@NotNull LighterAST tree, @Nullable LighterASTNode expression2) {
        while (expression2 != null && expression2.getTokenType() == JavaElementType.PARENTH_EXPRESSION) {
            expression2 = JavaLightTreeUtil.findExpressionChild(tree, expression2);
        }
        return expression2;
    }

    public static boolean hasExplicitModifier(@NotNull LighterAST tree, @Nullable LighterASTNode modifierListOwner, @NotNull IElementType modifierKeyword) {
        LighterASTNode modifierList = LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)modifierListOwner, (IElementType)JavaElementType.MODIFIER_LIST);
        return LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)modifierList, (IElementType)modifierKeyword) != null;
    }
}

