/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaStubPsiElement<T extends StubElement>
extends StubBasedPsiElementBase<T>
implements StubBasedPsiElement<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.JavaStubPsiElement");

    public JavaStubPsiElement(@NotNull T stub, @NotNull IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public JavaStubPsiElement(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public Language getLanguage() {
        return JavaLanguage.INSTANCE;
    }

    public int getTextOffset() {
        return this.calcTreeElement().getTextOffset();
    }

    protected CompositeElement calcTreeElement() {
        return (CompositeElement)this.getNode();
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement((PsiElement)element);
        this.calcTreeElement().addInternal(elementCopy, (ASTNode)elementCopy, null, null);
        elementCopy = ChangeUtil.decodeInformation((TreeElement)elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi((ASTNode)elementCopy);
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement((PsiElement)element);
        this.calcTreeElement().addInternal(elementCopy, (ASTNode)elementCopy, SourceTreeToPsiMap.psiElementToTree((PsiElement)anchor), Boolean.TRUE);
        elementCopy = ChangeUtil.decodeInformation((TreeElement)elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi((ASTNode)elementCopy);
    }

    public PsiElement addAfter(@NotNull PsiElement element, @Nullable PsiElement anchor) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        TreeElement elementCopy = ChangeUtil.copyToElement((PsiElement)element);
        this.calcTreeElement().addInternal(elementCopy, (ASTNode)elementCopy, SourceTreeToPsiMap.psiElementToTree((PsiElement)anchor), Boolean.FALSE);
        elementCopy = ChangeUtil.decodeInformation((TreeElement)elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi((ASTNode)elementCopy);
    }

    public final void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
    }

    public void delete() throws IncorrectOperationException {
        CompositeElement treeElement = this.calcTreeElement();
        LOG.assertTrue(treeElement.getTreeParent() != null);
        CheckUtil.checkWritable((PsiElement)this);
        ((CompositeElement)treeElement.getTreeParent()).deleteChildInternal((ASTNode)treeElement);
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        if (first == null) {
            LOG.assertTrue(last == null);
            return;
        }
        ASTNode firstElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)first);
        ASTNode lastElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)last);
        CompositeElement treeElement = this.calcTreeElement();
        LOG.assertTrue(firstElement.getTreeParent() == treeElement);
        LOG.assertTrue(lastElement.getTreeParent() == treeElement);
        CodeEditUtil.removeChildren((ASTNode)treeElement, (ASTNode)firstElement, (ASTNode)lastElement);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        CompositeElement treeElement = this.calcTreeElement();
        return SharedImplUtil.doReplace((PsiElement)this, (TreeElement)treeElement, (PsiElement)newElement);
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        SharedImplUtil.acceptChildren((PsiElementVisitor)visitor, (ASTNode)this.calcTreeElement());
    }

    protected Object clone() {
        CompositeElement treeElement = this.calcTreeElement();
        CompositeElement treeElementClone = (CompositeElement)(treeElement.getTreeParent() != null ? treeElement.copyElement() : treeElement.clone());
        return this.cloneImpl(treeElementClone);
    }

    protected StubBasedPsiElementBase cloneImpl(@NotNull CompositeElement treeElementClone) {
        StubBasedPsiElementBase clone = (StubBasedPsiElementBase)super.clone();
        clone.setNode((ASTNode)treeElementClone);
        treeElementClone.setPsi((PsiElement)clone);
        return clone;
    }

    public void subtreeChanged() {
        CompositeElement compositeElement = this.calcTreeElement();
        if (compositeElement != null) {
            compositeElement.clearCaches();
        }
        super.subtreeChanged();
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement psiChild = this.getFirstChild();
        if (psiChild == null) {
            return EMPTY_ARRAY;
        }
        int count = 0;
        while (psiChild != null) {
            ++count;
            psiChild = psiChild.getNextSibling();
        }
        PsiElement[] answer = new PsiElement[count];
        count = 0;
        for (psiChild = this.getFirstChild(); psiChild != null; psiChild = psiChild.getNextSibling()) {
            answer[count++] = psiChild;
        }
        return answer;
    }
}

