/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiImmediateClassType
extends PsiClassType.Stub {
    private final PsiClass myClass;
    private final PsiSubstitutor mySubstitutor;
    private final PsiManager myManager;
    private String myCanonicalText;
    private String myCanonicalTextAnnotated;
    private String myPresentableText;
    private String myInternalCanonicalText;
    private final PsiClassType.ClassResolveResult myClassResolveResult = new PsiClassType.ClassResolveResult(){

        public PsiClass getElement() {
            return PsiImmediateClassType.this.myClass;
        }

        @NotNull
        public PsiSubstitutor getSubstitutor() {
            return PsiImmediateClassType.this.mySubstitutor;
        }

        public boolean isValidResult() {
            return true;
        }

        public boolean isAccessible() {
            return true;
        }

        public boolean isStaticsScopeCorrect() {
            return true;
        }

        public PsiElement getCurrentFileResolveScope() {
            return null;
        }

        public boolean isPackagePrefixPackageReference() {
            return false;
        }
    };

    public PsiImmediateClassType(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor) {
        this(aClass, substitutor, null, TypeAnnotationProvider.EMPTY);
    }

    public PsiImmediateClassType(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel level) {
        this(aClass, substitutor, level, TypeAnnotationProvider.EMPTY);
    }

    public PsiImmediateClassType(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel level, PsiAnnotation ... annotations2) {
        super(level, annotations2);
        this.myClass = aClass;
        this.myManager = aClass.getManager();
        this.mySubstitutor = substitutor;
        assert (substitutor.isValid());
    }

    public PsiImmediateClassType(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor, @Nullable LanguageLevel level, @NotNull TypeAnnotationProvider provider) {
        super(level, provider);
        this.myClass = aClass;
        this.myManager = aClass.getManager();
        this.mySubstitutor = substitutor;
        substitutor.ensureValid();
    }

    public PsiClass resolve() {
        return this.myClass;
    }

    public String getClassName() {
        return this.myClass.getName();
    }

    @NotNull
    public PsiType[] getParameters() {
        PsiTypeParameter[] parameters2 = this.myClass.getTypeParameters();
        if (parameters2.length == 0) {
            return PsiType.EMPTY_ARRAY;
        }
        ArrayList<PsiType> lst = new ArrayList<PsiType>();
        for (PsiTypeParameter parameter2 : parameters2) {
            PsiType substituted = this.mySubstitutor.substitute(parameter2);
            if (substituted == null) {
                return PsiType.EMPTY_ARRAY;
            }
            lst.add(substituted);
        }
        return lst.toArray(PsiImmediateClassType.createArray((int)lst.size()));
    }

    @NotNull
    public PsiClassType.ClassResolveResult resolveGenerics() {
        return this.myClassResolveResult;
    }

    @NotNull
    public PsiClassType rawType() {
        return JavaPsiFacade.getElementFactory((Project)this.myClass.getProject()).createType(this.myClass);
    }

    @NotNull
    public String getPresentableText(boolean annotated) {
        if (this.myPresentableText == null) {
            this.myPresentableText = this.getText(TextType.PRESENTABLE, annotated);
        }
        return this.myPresentableText;
    }

    @NotNull
    public String getCanonicalText(boolean annotated) {
        String cached;
        String string = cached = annotated ? this.myCanonicalTextAnnotated : this.myCanonicalText;
        if (cached == null) {
            cached = this.getText(TextType.CANONICAL, annotated);
            if (annotated) {
                this.myCanonicalTextAnnotated = cached;
            } else {
                this.myCanonicalText = cached;
            }
        }
        return cached;
    }

    @NotNull
    public String getInternalCanonicalText() {
        if (this.myInternalCanonicalText == null) {
            this.myInternalCanonicalText = this.getText(TextType.INT_CANONICAL, true);
        }
        return this.myInternalCanonicalText;
    }

    private String getText(@NotNull TextType textType, boolean annotated) {
        this.mySubstitutor.ensureValid();
        StringBuilder buffer = new StringBuilder();
        this.buildText(this.myClass, this.mySubstitutor, buffer, textType, annotated);
        return buffer.toString();
    }

    private void buildText(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor, @NotNull StringBuilder buffer, @NotNull TextType textType, boolean annotated) {
        String prefix;
        String fqn;
        PsiElement parent;
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType.ClassResolveResult baseResolveResult = ((PsiAnonymousClass)aClass).getBaseClassType().resolveGenerics();
            PsiClass baseClass = baseResolveResult.getElement();
            if (textType == TextType.INT_CANONICAL) {
                buffer.append("anonymous ");
            }
            if (baseClass != null) {
                this.buildText(baseClass, baseResolveResult.getSubstitutor(), buffer, textType, false);
            } else {
                buffer.append(((PsiAnonymousClass)aClass).getBaseClassReference().getCanonicalText());
            }
            return;
        }
        boolean qualified = textType != TextType.PRESENTABLE;
        PsiClass enclosingClass = null;
        if (!aClass.hasModifierProperty("static") && (parent = aClass.getParent()) instanceof PsiClass && !(parent instanceof PsiAnonymousClass)) {
            enclosingClass = (PsiClass)parent;
        }
        if (enclosingClass != null) {
            this.buildText(enclosingClass, substitutor, buffer, textType, false);
            buffer.append('.');
        } else if (qualified && (fqn = aClass.getQualifiedName()) != null && !StringUtil.isEmpty((String)(prefix = StringUtil.getPackageName((String)fqn)))) {
            buffer.append(prefix);
            buffer.append('.');
        }
        if (annotated) {
            PsiNameHelper.appendAnnotations((StringBuilder)buffer, (PsiAnnotation[])this.getAnnotations(), (boolean)qualified);
        }
        buffer.append(aClass.getName());
        PsiTypeParameter[] typeParameters = aClass.getTypeParameters();
        if (typeParameters.length > 0) {
            int pos = buffer.length();
            buffer.append('<');
            for (int i = 0; i < typeParameters.length; ++i) {
                PsiType substitutionResult;
                PsiTypeParameter typeParameter = typeParameters[i];
                PsiUtilCore.ensureValid((PsiElement)typeParameter);
                if (i > 0) {
                    buffer.append(',');
                    if (textType == TextType.PRESENTABLE) {
                        buffer.append(' ');
                    }
                }
                if ((substitutionResult = substitutor.substitute(typeParameter)) == null) {
                    buffer.setLength(pos);
                    pos = -1;
                    break;
                }
                PsiUtil.ensureValidType((PsiType)substitutionResult);
                if (textType == TextType.PRESENTABLE) {
                    buffer.append(substitutionResult.getPresentableText());
                    continue;
                }
                if (textType == TextType.CANONICAL) {
                    buffer.append(substitutionResult.getCanonicalText(annotated));
                    continue;
                }
                buffer.append(substitutionResult.getInternalCanonicalText());
            }
            if (pos >= 0) {
                buffer.append('>');
            }
        }
    }

    public boolean isValid() {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            if (annotation.isValid()) continue;
            return false;
        }
        return this.myClass.isValid() && this.mySubstitutor.isValid();
    }

    public boolean equalsToText(@NotNull String text2) {
        PsiType patternType;
        String name = this.myClass.getName();
        if (name == null || !text2.contains(name)) {
            return false;
        }
        if (text2.equals(this.getCanonicalText(false))) {
            return true;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
        try {
            patternType = factory.createTypeFromText(text2, (PsiElement)this.myClass);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return this.equals(patternType);
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        return this.myClass.getResolveScope();
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel != null ? this.myLanguageLevel : PsiUtil.getLanguageLevel((PsiElement)this.myClass);
    }

    @NotNull
    public PsiClassType setLanguageLevel(@NotNull LanguageLevel level) {
        return level.equals((Object)this.myLanguageLevel) ? this : new PsiImmediateClassType(this.myClass, this.mySubstitutor, level, this.getAnnotationProvider());
    }

    private static enum TextType {
        PRESENTABLE,
        CANONICAL,
        INT_CANONICAL;

    }
}

