/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiImportListStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.PsiImportStatementImpl;
import com.intellij.psi.impl.source.PsiImportStaticStatementImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayFactory;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PsiImportListImpl
extends JavaStubPsiElement<PsiImportListStub>
implements PsiImportList {
    private volatile Map<String, PsiImportStatement> myClassNameToImportMap;
    private volatile Map<String, PsiImportStatement> myPackageNameToImportMap;
    private volatile Map<String, PsiImportStatementBase> myNameToSingleImportMap;
    private static final PsiImportStatementBase[] EMPTY_ARRAY = PsiImportStatementBase.EMPTY_ARRAY;
    private static final ArrayFactory<PsiImportStatementBase> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new PsiImportStatementBase[count];
    private static final TokenSet IMPORT_STATEMENT_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.IMPORT_STATEMENT});
    private static final TokenSet IMPORT_STATIC_STATEMENT_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.IMPORT_STATIC_STATEMENT});

    public PsiImportListImpl(PsiImportListStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.IMPORT_LIST);
    }

    public PsiImportListImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected Object clone() {
        PsiImportListImpl clone = (PsiImportListImpl)((Object)super.clone());
        clone.myClassNameToImportMap = null;
        clone.myPackageNameToImportMap = null;
        clone.myNameToSingleImportMap = null;
        return clone;
    }

    @Override
    public void subtreeChanged() {
        this.myClassNameToImportMap = null;
        this.myPackageNameToImportMap = null;
        this.myNameToSingleImportMap = null;
        super.subtreeChanged();
    }

    @NotNull
    public PsiImportStatement[] getImportStatements() {
        return (PsiImportStatement[])this.getStubOrPsiChildren(IMPORT_STATEMENT_BIT_SET, PsiImportStatementImpl.ARRAY_FACTORY);
    }

    @NotNull
    public PsiImportStaticStatement[] getImportStaticStatements() {
        return (PsiImportStaticStatement[])this.getStubOrPsiChildren(IMPORT_STATIC_STATEMENT_BIT_SET, PsiImportStaticStatementImpl.ARRAY_FACTORY);
    }

    @NotNull
    public PsiImportStatementBase[] getAllImportStatements() {
        return (PsiImportStatementBase[])this.getStubOrPsiChildren(ElementType.IMPORT_STATEMENT_BASE_BIT_SET, ARRAY_FACTORY);
    }

    public PsiImportStatement findSingleClassImportStatement(String name) {
        Map<String, PsiImportStatement> map2;
        while ((map2 = this.myClassNameToImportMap) == null) {
            this.initializeMaps();
        }
        return map2.get(name);
    }

    public PsiImportStatement findOnDemandImportStatement(String name) {
        Map<String, PsiImportStatement> map2;
        while ((map2 = this.myPackageNameToImportMap) == null) {
            this.initializeMaps();
        }
        return map2.get(name);
    }

    public PsiImportStatementBase findSingleImportStatement(String name) {
        Map<String, PsiImportStatementBase> map2;
        while ((map2 = this.myNameToSingleImportMap) == null) {
            this.initializeMaps();
        }
        return map2.get(name);
    }

    public boolean isReplaceEquivalent(PsiImportList otherList) {
        return this.getText().equals(otherList.getText());
    }

    private void initializeMaps() {
        PsiImportStaticStatement[] importStatics;
        PsiImportStatement[] imports2;
        HashMap<String, PsiImportStatement> classNameToImportMap = new HashMap<String, PsiImportStatement>();
        HashMap<String, PsiImportStatement> packageNameToImportMap = new HashMap<String, PsiImportStatement>();
        HashMap<String, PsiImportStatementBase> nameToSingleImportMap = new HashMap<String, PsiImportStatementBase>();
        for (PsiImportStatement anImport : imports2 = this.getImportStatements()) {
            String qName = anImport.getQualifiedName();
            if (qName == null) continue;
            if (anImport.isOnDemand()) {
                packageNameToImportMap.put(qName, anImport);
                continue;
            }
            classNameToImportMap.put(qName, anImport);
            PsiJavaCodeReferenceElement importReference2 = anImport.getImportReference();
            if (importReference2 == null) continue;
            nameToSingleImportMap.put(importReference2.getReferenceName(), (PsiImportStatementBase)anImport);
        }
        for (PsiImportStaticStatement importStatic : importStatics = this.getImportStaticStatements()) {
            String referenceName;
            if (importStatic.isOnDemand() || (referenceName = importStatic.getReferenceName()) == null) continue;
            nameToSingleImportMap.put(referenceName, (PsiImportStatementBase)importStatic);
        }
        this.myClassNameToImportMap = classNameToImportMap;
        this.myPackageNameToImportMap = packageNameToImportMap;
        this.myNameToSingleImportMap = nameToSingleImportMap;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitImportList((PsiImportList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiImportList";
    }
}

