/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.StaticImportResolveProcessor;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiImportStaticReferenceElementImpl
extends CompositePsiElement
implements PsiImportStaticReferenceElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiImportStaticReferenceElementImpl");
    private volatile String myCanonicalText;

    public PsiImportStaticReferenceElementImpl() {
        super(JavaElementType.IMPORT_STATIC_REFERENCE);
    }

    public int getTextOffset() {
        ASTNode refName = this.findChildByRole(53);
        if (refName != null) {
            return refName.getStartOffset();
        }
        return super.getTextOffset();
    }

    public void clearCaches() {
        super.clearCaches();
        this.myCanonicalText = null;
    }

    public final ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 53: {
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 54: {
                TreeElement node = this.getFirstChildNode();
                return node.getElementType() == JavaElementType.JAVA_CODE_REFERENCE ? node : null;
            }
            case 55: 
        }
        return this.findChildByType(JavaTokenType.DOT);
    }

    public final int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            return 54;
        }
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaTokenType.IDENTIFIER) {
            return 53;
        }
        return 0;
    }

    public PsiElement getReferenceNameElement() {
        return this.findChildByRoleAsPsiElement(53);
    }

    public PsiReferenceParameterList getParameterList() {
        return null;
    }

    @NotNull
    public PsiType[] getTypeParameters() {
        return PsiType.EMPTY_ARRAY;
    }

    public PsiElement getQualifier() {
        return this.findChildByRoleAsPsiElement(54);
    }

    public PsiJavaCodeReferenceElement getClassReference() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(54);
    }

    public PsiImportStaticStatement bindToTargetClass(PsiClass aClass) throws IncorrectOperationException {
        String qualifiedName = aClass.getQualifiedName();
        if (qualifiedName == null) {
            throw new IncorrectOperationException();
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)this.getProject()).getParserFacade();
        CompositeElement newRef = (CompositeElement)parserFacade.createReferenceFromText(qualifiedName, null).getNode();
        if (this.getQualifier() != null) {
            this.replaceChildInternal(this.findChildByRole(54), (TreeElement)newRef);
            return (PsiImportStaticStatement)this.getParent();
        }
        LeafElement dot = Factory.createSingleLeafElement((IElementType)JavaTokenType.DOT, (CharSequence)".", (int)0, (int)1, (CharTable)SharedImplUtil.findCharTableByTree((ASTNode)newRef), (PsiManager)this.getManager());
        newRef.rawInsertAfterMe((TreeElement)dot);
        CompositeElement errorElement = Factory.createErrorElement((String)JavaErrorMessages.message("import.statement.identifier.or.asterisk.expected.", new Object[0]));
        dot.rawInsertAfterMe((TreeElement)errorElement);
        CompositeElement parentComposite = (CompositeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)this.getParent());
        parentComposite.addInternal((TreeElement)newRef, (ASTNode)errorElement, (ASTNode)this, Boolean.TRUE);
        parentComposite.deleteChildInternal((ASTNode)this);
        return (PsiImportStaticStatement)SourceTreeToPsiMap.treeElementToPsi((ASTNode)parentComposite);
    }

    public boolean isQualified() {
        return this.findChildByRole(54) != null;
    }

    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    public boolean isSoft() {
        return false;
    }

    public String getReferenceName() {
        ASTNode childByRole = this.findChildByRole(53);
        if (childByRole == null) {
            return "";
        }
        return childByRole.getText();
    }

    @NotNull
    public PsiElement getElement() {
        return this;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TreeElement nameChild = (TreeElement)this.findChildByRole(53);
        if (nameChild == null) {
            return new TextRange(0, this.getTextLength());
        }
        int startOffset = nameChild.getStartOffsetInParent();
        return new TextRange(startOffset, startOffset + nameChild.getTextLength());
    }

    @NotNull
    public String getCanonicalText() {
        String canonicalText = this.myCanonicalText;
        if (canonicalText == null) {
            this.myCanonicalText = canonicalText = this.calcCanonicalText();
        }
        return canonicalText;
    }

    private String calcCanonicalText() {
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)this.getQualifier();
        if (referenceElement == null) {
            return this.getReferenceName();
        }
        return referenceElement.getCanonicalText() + "." + this.getReferenceName();
    }

    public String toString() {
        return "PsiImportStaticReferenceElement:" + this.getText();
    }

    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        if (results.length == 1) {
            return results[0];
        }
        return JavaResolveResult.EMPTY;
    }

    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file = this.getContainingFile();
        ResolveCache resolveCache = ResolveCache.getInstance((Project)file.getProject());
        ResolveResult[] results = resolveCache.resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantResolver)OurGenericsResolver.INSTANCE, true, incompleteCode, file);
        return results instanceof JavaResolveResult[] ? (JavaResolveResult[])results : JavaResolveResult.EMPTY_ARRAY;
    }

    public PsiReference getReference() {
        return this;
    }

    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        String name = this.getReferenceName();
        if (name == null || !(element instanceof PsiNamedElement) || !name.equals(((PsiNamedElement)element).getName())) {
            return false;
        }
        for (JavaResolveResult result : this.multiResolve(false)) {
            if (!this.getManager().areElementsEquivalent(result.getElement(), element)) continue;
            return true;
        }
        return false;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getElementFactory((Project)this.getProject()).createIdentifier(newElementName);
        oldIdentifier.replace((PsiElement)identifier);
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (!(element instanceof PsiMember) || !(element instanceof PsiNamedElement) || ((PsiNamedElement)element).getName() == null) {
            throw new IncorrectOperationException();
        }
        if (!((PsiModifierListOwner)element).hasModifierProperty("static")) {
            if (element instanceof PsiClass && ((PsiClass)element).getContainingClass() == null) {
                return this.replaceWithRegularImport((PsiClass)element);
            }
            throw new IncorrectOperationException();
        }
        PsiClass containingClass = ((PsiMember)element).getContainingClass();
        if (containingClass == null) {
            throw new IncorrectOperationException();
        }
        PsiElement qualifier = this.getQualifier();
        if (qualifier == null) {
            throw new IncorrectOperationException();
        }
        ((PsiReference)qualifier).bindToElement((PsiElement)containingClass);
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        PsiIdentifier identifier = JavaPsiFacade.getElementFactory((Project)this.getProject()).createIdentifier(((PsiNamedElement)element).getName());
        oldIdentifier.replace((PsiElement)identifier);
        return this;
    }

    private PsiElement replaceWithRegularImport(PsiClass psiClass) throws IncorrectOperationException {
        PsiImportStaticStatement baseStatement = (PsiImportStaticStatement)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiImportStaticStatement.class);
        PsiImportStatement statement = JavaPsiFacade.getElementFactory((Project)this.getProject()).createImportStatement(psiClass);
        statement = (PsiImportStatement)baseStatement.replace((PsiElement)statement);
        PsiJavaCodeReferenceElement reference = statement.getImportReference();
        assert (reference != null);
        return reference;
    }

    public void processVariants(@NotNull PsiScopeProcessor processor) {
        FilterScopeProcessor proc = new FilterScopeProcessor((ElementFilter)new ClassFilter(PsiModifierListOwner.class), processor);
        PsiScopesUtil.resolveAndWalk(proc, (PsiJavaCodeReferenceElement)this, null, true);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitImportStaticReferenceElement((PsiImportStaticReferenceElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    private static final class OurGenericsResolver
    implements ResolveCache.PolyVariantResolver<PsiImportStaticReferenceElementImpl> {
        private static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        private OurGenericsResolver() {
        }

        @NotNull
        public JavaResolveResult[] resolve(@NotNull PsiImportStaticReferenceElementImpl referenceElement, boolean incompleteCode) {
            PsiElement qualifier = referenceElement.getQualifier();
            if (!(qualifier instanceof PsiJavaCodeReferenceElement)) {
                return JavaResolveResult.EMPTY_ARRAY;
            }
            PsiElement target = ((PsiJavaCodeReferenceElement)qualifier).resolve();
            if (!(target instanceof PsiClass)) {
                return JavaResolveResult.EMPTY_ARRAY;
            }
            StaticImportResolveProcessor processor = new StaticImportResolveProcessor(referenceElement);
            target.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)referenceElement, (PsiElement)referenceElement);
            return processor.getResults();
        }
    }
}

