/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.SymbolCollectingProcessor;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.indexing.IndexingDataKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiJavaFileBaseImpl
extends PsiFileImpl
implements PsiJavaFile {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiJavaFileBaseImpl");
    private static final String[] IMPLICIT_IMPORTS = new String[]{"java.lang"};
    private final CachedValue<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> myResolveCache;
    private volatile String myPackageName;
    private static final NotNullLazyKey<LanguageLevel, PsiJavaFileBaseImpl> LANGUAGE_LEVEL_KEY = NotNullLazyKey.create((String)"LANGUAGE_LEVEL", file -> file.getLanguageLevelInner());

    protected PsiJavaFileBaseImpl(IElementType elementType, IElementType contentElementType, FileViewProvider viewProvider) {
        super(elementType, contentElementType, viewProvider);
        this.myResolveCache = CachedValuesManager.getManager((Project)this.myManager.getProject()).createCachedValue((CachedValueProvider)new MyCacheBuilder(this), false);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myPackageName = null;
    }

    @NotNull
    public PsiClass[] getClasses() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            return (PsiClass[])stub.getChildrenByType((IElementType)JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
        }
        return (PsiClass[])this.calcTreeElement().getChildrenAsPsiElements(Constants.CLASS_BIT_SET, PsiClass.ARRAY_FACTORY);
    }

    public PsiPackageStatement getPackageStatement() {
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.PACKAGE_STATEMENT);
        return node != null ? (PsiPackageStatement)node.getPsi() : null;
    }

    @NotNull
    public String getPackageName() {
        PsiJavaFileStub stub = (PsiJavaFileStub)this.getGreenStub();
        if (stub != null) {
            return stub.getPackageName();
        }
        String name = this.myPackageName;
        if (name == null) {
            PsiPackageStatement statement = this.getPackageStatement();
            name = statement == null ? "" : statement.getPackageName();
            this.myPackageName = name;
        }
        return name;
    }

    public void setPackageName(String packageName) throws IncorrectOperationException {
        if (PsiUtil.isModuleFile((PsiFile)this)) {
            throw new IncorrectOperationException("Cannot set package name for module declarations");
        }
        PsiPackageStatement packageStatement = this.getPackageStatement();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.getProject());
        if (packageStatement != null) {
            if (!packageName.isEmpty()) {
                PsiJavaCodeReferenceElement reference = packageStatement.getPackageReference();
                reference.replace((PsiElement)factory.createReferenceFromText(packageName, (PsiElement)packageStatement));
            } else {
                packageStatement.delete();
            }
        } else if (!packageName.isEmpty()) {
            this.cleanupBrokenPackageKeyword();
            PsiElement anchor = this.getFirstChild();
            if ("package-info.java".equals(this.getName())) {
                String text2;
                anchor = this.getImportList();
                assert (anchor != null);
                PsiElement prev = anchor.getPrevSibling();
                if (prev instanceof PsiComment && (text2 = prev.getText().trim()).startsWith("/*") && !text2.endsWith("*/")) {
                    prev.replace((PsiElement)factory.createCommentFromText(text2 + (StringUtil.containsLineBreak((CharSequence)text2) ? "\n*/" : " */"), prev));
                }
            }
            this.addBefore((PsiElement)factory.createPackageStatement(packageName), anchor);
        }
    }

    private void cleanupBrokenPackageKeyword() {
        PsiElement child = this.getFirstChild();
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof PsiErrorElement) {
            if (child instanceof PsiErrorElement && child.getFirstChild() != null && child.getFirstChild().textMatches((CharSequence)"package")) {
                child.delete();
                break;
            }
            child = child.getNextSibling();
        }
    }

    public PsiImportList getImportList() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            PsiImportList[] nodes = (PsiImportList[])stub.getChildrenByType((IElementType)JavaStubElementTypes.IMPORT_LIST, PsiImportList.ARRAY_FACTORY);
            if (nodes.length == 1) {
                return nodes[0];
            }
            assert (nodes.length == 0);
            return null;
        }
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.IMPORT_LIST);
        return (PsiImportList)SourceTreeToPsiMap.treeElementToPsi((ASTNode)node);
    }

    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            return EMPTY_ARRAY;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement resolved;
            if (!statement.isOnDemand() || (resolved = statement.resolve()) == null) continue;
            array.add(resolved);
        }
        if (includeImplicit) {
            PsiJavaCodeReferenceElement[] implicitRefs;
            for (PsiJavaCodeReferenceElement implicitRef : implicitRefs = this.getImplicitlyImportedPackageReferences()) {
                PsiElement resolved = implicitRef.resolve();
                if (resolved == null) continue;
                array.add(resolved);
            }
        }
        return PsiUtilCore.toPsiElementArray(array);
    }

    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> array = new ArrayList<PsiClass>();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement ref;
            if (statement.isOnDemand() || !((ref = statement.resolve()) instanceof PsiClass)) continue;
            array.add((PsiClass)ref);
        }
        return array.toArray(PsiClass.EMPTY_ARRAY);
    }

    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass) {
        PsiImportList importList = this.getImportList();
        if (importList != null) {
            PsiImportStatement[] statements;
            for (PsiImportStatement statement : statements = importList.getImportStatements()) {
                PsiElement ref;
                if (statement.isOnDemand() || (ref = statement.resolve()) == null || !this.getManager().areElementsEquivalent(ref, (PsiElement)aClass)) continue;
                return statement.getImportReference();
            }
        }
        return null;
    }

    @NotNull
    public String[] getImplicitlyImportedPackages() {
        return IMPLICIT_IMPORTS;
    }

    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        return PsiImplUtil.namesToPackageReferences((PsiManager)this.myManager, IMPLICIT_IMPORTS);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        assert (this.isValid());
        if (processor instanceof ClassResolverProcessor && this.isPhysical() && (this.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING) == Boolean.TRUE || this.myResolveCache.hasUpToDateValue()) && !PsiUtil.isInsideJavadocComment((PsiElement)place)) {
            ClassResolverProcessor hint = (ClassResolverProcessor)processor;
            String name = hint.getName(state);
            MostlySingularMultiMap cache = (MostlySingularMultiMap)this.myResolveCache.getValue();
            MyResolveCacheProcessor cacheProcessor = new MyResolveCacheProcessor(processor, state);
            return name != null ? cache.processForKey((Object)name, (Processor)cacheProcessor) : cache.processAllValues((Processor)cacheProcessor);
        }
        return this.processDeclarationsNoGuess(processor, state, lastParent, place);
    }

    private boolean processDeclarationsNoGuess(PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, PsiElement place) {
        PsiImportList importList = this.getImportList();
        PsiImportStatement[] importStatements = importList != null ? importList.getImportStatements() : PsiImportStatement.EMPTY_ARRAY;
        PsiImportStaticStatement[] importStaticStatements = importList != null ? importList.getImportStaticStatements() : PsiImportStaticStatement.EMPTY_ARRAY;
        StaticImportFilteringProcessor staticImportProcessor = new StaticImportFilteringProcessor(processor);
        boolean shouldProcessClasses = PsiJavaFileBaseImpl.shouldProcessClasses(processor);
        if (shouldProcessClasses && !this.processOwnClasses(processor, state)) {
            return false;
        }
        if (!PsiJavaFileBaseImpl.processNamedImports(state, importStatements, importStaticStatements, staticImportProcessor)) {
            return false;
        }
        if (shouldProcessClasses) {
            if (!this.processCurrentPackage(processor, state, place)) {
                return false;
            }
            if (!PsiJavaFileBaseImpl.processOnDemandTypeImports(processor, state, place, importStatements)) {
                return false;
            }
        }
        if (!PsiJavaFileBaseImpl.processOnDemandStaticImports(state, lastParent, place, importStaticStatements, staticImportProcessor)) {
            return false;
        }
        return !shouldProcessClasses || this.processImplicitImports(processor, state, place);
    }

    private boolean processOwnClasses(PsiScopeProcessor processor, @NotNull ResolveState state) {
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        for (PsiClass aClass : this.getClasses()) {
            if (processor.execute((PsiElement)aClass, state)) continue;
            return false;
        }
        return true;
    }

    private static boolean shouldProcessClasses(PsiScopeProcessor processor) {
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        return classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS);
    }

    private static boolean processNamedImports(ResolveState state, PsiImportStatement[] importStatements, PsiImportStaticStatement[] importStaticStatements, StaticImportFilteringProcessor staticImportProcessor) {
        String name;
        PsiScopeProcessor processor = staticImportProcessor.myDelegate;
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String string = name = nameHint != null ? nameHint.getName(state) : null;
        if (PsiJavaFileBaseImpl.shouldProcessClasses(processor) && !PsiJavaFileBaseImpl.processNamedTypeImports(processor, state, name, importStatements)) {
            return false;
        }
        return PsiJavaFileBaseImpl.processNamedStaticImports(state, name, importStaticStatements, staticImportProcessor);
    }

    private static boolean processNamedTypeImports(PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable String nameHint, PsiImportStatement[] imports2) {
        for (PsiImportStatement statement : imports2) {
            ResolveState classState;
            PsiElement resolved;
            String refText;
            if (statement.isOnDemand() || nameHint != null && ((refText = statement.getQualifiedName()) == null || !nameHint.equals(StringUtil.getShortName((String)refText))) || !((resolved = statement.resolve()) instanceof PsiClass)) continue;
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)statement);
            PsiClass containingClass = ((PsiClass)resolved).getContainingClass();
            ResolveState resolveState = classState = containingClass != null && containingClass.hasTypeParameters() ? state.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor(containingClass)) : state;
            if (processor.execute(resolved, classState)) continue;
            return false;
        }
        return true;
    }

    private boolean processCurrentPackage(PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findPackage(this.getPackageName());
        return aPackage == null || PsiJavaFileBaseImpl.processPackageDeclarations(processor, state, place, aPackage);
    }

    private static boolean processOnDemandTypeImports(PsiScopeProcessor processor, ResolveState state, PsiElement place, PsiImportStatement[] imports2) {
        for (PsiImportStatement statement : imports2) {
            PsiElement resolved;
            if (!statement.isOnDemand() || (resolved = statement.resolve()) == null) continue;
            processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)statement);
            if (PsiJavaFileBaseImpl.processOnDemandTarget(resolved, processor, state, place)) continue;
            return false;
        }
        return true;
    }

    private static boolean processNamedStaticImports(@NotNull ResolveState state, @Nullable String nameHint, @NotNull PsiImportStaticStatement[] importStaticStatements, StaticImportFilteringProcessor staticImportProcessor) {
        for (PsiImportStaticStatement importStaticStatement : importStaticStatements) {
            JavaResolveResult[] results;
            PsiJavaCodeReferenceElement reference;
            if (importStaticStatement.isOnDemand()) continue;
            String referenceName = importStaticStatement.getReferenceName();
            if (nameHint != null && !nameHint.equals(referenceName) || (reference = importStaticStatement.getImportReference()) == null || (results = reference.multiResolve(false)).length <= 0) continue;
            staticImportProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, importStaticStatement);
            for (JavaResolveResult result : results) {
                staticImportProcessor.registerSingleStaticImportHiding(result, referenceName);
                PsiElement element = result.getElement();
                if (element == null || staticImportProcessor.execute(element, state)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processOnDemandStaticImports(@NotNull ResolveState state, PsiElement lastParent, PsiElement place, PsiImportStaticStatement[] importStaticStatements, StaticImportFilteringProcessor staticImportProcessor) {
        for (PsiImportStaticStatement importStaticStatement : importStaticStatements) {
            PsiClass targetElement;
            if (!importStaticStatement.isOnDemand() || (targetElement = importStaticStatement.resolveTargetClass()) == null) continue;
            staticImportProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, importStaticStatement);
            if (targetElement.processDeclarations((PsiScopeProcessor)staticImportProcessor, state, lastParent, place)) continue;
            return false;
        }
        return true;
    }

    private boolean processImplicitImports(PsiScopeProcessor processor, ResolveState state, PsiElement place) {
        processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
        for (PsiJavaCodeReferenceElement aImplicitlyImported : this.getImplicitlyImportedPackageReferences()) {
            PsiElement resolved = aImplicitlyImported.resolve();
            if (resolved == null || PsiJavaFileBaseImpl.processOnDemandTarget(resolved, processor, state, place)) continue;
            return false;
        }
        return true;
    }

    private static boolean processPackageDeclarations(PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement place, @NotNull PsiPackage aPackage) {
        if (!aPackage.getQualifiedName().isEmpty()) {
            processor = new DelegatingScopeProcessor((PsiScopeProcessor)processor){

                @Nullable
                public <T> T getHint(@NotNull Key<T> hintKey) {
                    if (hintKey == ElementClassHint.KEY) {
                        return (T)((ElementClassHint)kind2 -> kind2 == ElementClassHint.DeclarationKind.CLASS);
                    }
                    return (T)super.getHint(hintKey);
                }
            };
        }
        return aPackage.processDeclarations(processor, state, null, place);
    }

    @NotNull
    private static PsiSubstitutor createRawSubstitutor(PsiClass containingClass) {
        return JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)containingClass);
    }

    private static boolean processOnDemandTarget(PsiElement target, PsiScopeProcessor processor, ResolveState substitutor, PsiElement place) {
        if (target instanceof PsiPackage) {
            if (!PsiJavaFileBaseImpl.processPackageDeclarations(processor, substitutor, place, (PsiPackage)target)) {
                return false;
            }
        } else if (target instanceof PsiClass) {
            PsiClass[] inners = ((PsiClass)target).getInnerClasses();
            if (((PsiClass)target).hasTypeParameters()) {
                substitutor = substitutor.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor((PsiClass)target));
            }
            for (PsiClass inner : inners) {
                if (processor.execute((PsiElement)inner, substitutor)) continue;
                return false;
            }
        } else {
            LOG.error((Object)target);
        }
        return true;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitJavaFile((PsiJavaFile)this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    @NotNull
    public Language getLanguage() {
        return JavaLanguage.INSTANCE;
    }

    public boolean importClass(@NotNull PsiClass aClass) {
        return JavaCodeStyleManager.getInstance((Project)this.getProject()).addImport((PsiJavaFile)this, aClass);
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        return (LanguageLevel)LANGUAGE_LEVEL_KEY.getValue((UserDataHolder)this);
    }

    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        return null;
    }

    public void clearCaches() {
        super.clearCaches();
        this.putUserData((Key)LANGUAGE_LEVEL_KEY, null);
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        super.setOriginalFile(originalFile);
        this.clearCaches();
    }

    private LanguageLevel getLanguageLevelInner() {
        if (this.myOriginalFile instanceof PsiJavaFile) {
            return ((PsiJavaFile)this.myOriginalFile).getLanguageLevel();
        }
        LanguageLevel forcedLanguageLevel = (LanguageLevel)this.getUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY);
        if (forcedLanguageLevel != null) {
            return forcedLanguageLevel;
        }
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            virtualFile = (VirtualFile)this.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        }
        Project project = this.getProject();
        if (virtualFile == null) {
            PsiFile originalFile = this.getOriginalFile();
            if (originalFile instanceof PsiJavaFile && originalFile != this) {
                return ((PsiJavaFile)originalFile).getLanguageLevel();
            }
            return LanguageLevel.HIGHEST;
        }
        return JavaPsiImplementationHelper.getInstance(project).getEffectiveLanguageLevel(virtualFile);
    }

    private static class MyResolveCacheProcessor
    implements Processor<SymbolCollectingProcessor.ResultWithContext> {
        private final PsiScopeProcessor myProcessor;
        private final ResolveState myState;

        MyResolveCacheProcessor(PsiScopeProcessor processor, ResolveState state) {
            this.myProcessor = processor;
            this.myState = state;
        }

        public boolean process(SymbolCollectingProcessor.ResultWithContext result) {
            PsiClass containingClass;
            PsiElement context = result.getFileContext();
            this.myProcessor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)context);
            PsiNamedElement element = result.getElement();
            if (element instanceof PsiClass && context instanceof PsiImportStatement && (containingClass = ((PsiClass)element).getContainingClass()) != null && containingClass.hasTypeParameters()) {
                return this.myProcessor.execute((PsiElement)element, this.myState.put(PsiSubstitutor.KEY, (Object)PsiJavaFileBaseImpl.createRawSubstitutor(containingClass)));
            }
            return this.myProcessor.execute((PsiElement)element, this.myState);
        }
    }

    private static class MyCacheBuilder
    implements CachedValueProvider<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> {
        private final PsiJavaFileBaseImpl myFile;

        MyCacheBuilder(PsiJavaFileBaseImpl file) {
            this.myFile = file;
        }

        public CachedValueProvider.Result<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> compute() {
            SymbolCollectingProcessor p = new SymbolCollectingProcessor();
            this.myFile.processDeclarationsNoGuess(p, ResolveState.initial(), (PsiElement)this.myFile, (PsiElement)this.myFile);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> results = p.getResults();
            return CachedValueProvider.Result.create(results, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this.myFile});
        }
    }

    private static class StaticImportFilteringProcessor
    implements PsiScopeProcessor {
        private final PsiScopeProcessor myDelegate;
        private boolean myIsProcessingOnDemand;
        private final Collection<String> myHiddenFieldNames = new HashSet<String>();
        private final Collection<String> myHiddenMethodNames = new HashSet<String>();
        private final Collection<String> myHiddenTypeNames = new HashSet<String>();
        private final Collection<PsiElement> myCollectedElements = new HashSet<PsiElement>();

        StaticImportFilteringProcessor(PsiScopeProcessor delegate) {
            this.myDelegate = delegate;
        }

        public <T> T getHint(@NotNull Key<T> hintKey) {
            return (T)this.myDelegate.getHint(hintKey);
        }

        public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
            if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event) && associated instanceof PsiImportStaticStatement) {
                PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)associated;
                this.myIsProcessingOnDemand = importStaticStatement.isOnDemand();
            }
            this.myDelegate.handleEvent(event, associated);
        }

        private void registerSingleStaticImportHiding(JavaResolveResult result, String referenceName) {
            this.getHiddenMembers(result.getElement()).add(referenceName);
        }

        private Collection<String> getHiddenMembers(PsiElement element) {
            if (element instanceof PsiField) {
                return this.myHiddenFieldNames;
            }
            return element instanceof PsiClass ? this.myHiddenTypeNames : this.myHiddenMethodNames;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("static")) {
                if (element instanceof PsiNamedElement && this.myIsProcessingOnDemand) {
                    String name = ((PsiNamedElement)element).getName();
                    if (this.getHiddenMembers(element).contains(name)) {
                        return true;
                    }
                }
                if (this.myCollectedElements.add(element)) {
                    return this.myDelegate.execute(element, state);
                }
            }
            return true;
        }
    }
}

