/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaModuleStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaModuleImpl
extends JavaStubPsiElement<PsiJavaModuleStub>
implements PsiJavaModule {
    public PsiJavaModuleImpl(@NotNull PsiJavaModuleStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.MODULE);
    }

    public PsiJavaModuleImpl(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public Iterable<PsiRequiresStatement> getRequires() {
        PsiJavaModuleStub stub = (PsiJavaModuleStub)this.getGreenStub();
        if (stub != null) {
            return JBIterable.of((Object[])stub.getChildrenByType(JavaElementType.REQUIRES_STATEMENT, (PsiElement[])PsiRequiresStatement.EMPTY_ARRAY));
        }
        return SyntaxTraverser.psiTraverser().children((Object)this).filter(PsiRequiresStatement.class);
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getExports() {
        PsiJavaModuleStub stub = (PsiJavaModuleStub)this.getGreenStub();
        if (stub != null) {
            return JBIterable.of((Object[])stub.getChildrenByType(JavaElementType.EXPORTS_STATEMENT, (PsiElement[])PsiPackageAccessibilityStatement.EMPTY_ARRAY));
        }
        return SyntaxTraverser.psiTraverser().children((Object)this).filter(PsiPackageAccessibilityStatement.class).filter(statement -> statement.getRole() == PsiPackageAccessibilityStatement.Role.EXPORTS);
    }

    @NotNull
    public Iterable<PsiPackageAccessibilityStatement> getOpens() {
        PsiJavaModuleStub stub = (PsiJavaModuleStub)this.getGreenStub();
        if (stub != null) {
            return JBIterable.of((Object[])stub.getChildrenByType(JavaElementType.OPENS_STATEMENT, (PsiElement[])PsiPackageAccessibilityStatement.EMPTY_ARRAY));
        }
        return SyntaxTraverser.psiTraverser().children((Object)this).filter(PsiPackageAccessibilityStatement.class).filter(statement -> statement.getRole() == PsiPackageAccessibilityStatement.Role.OPENS);
    }

    @NotNull
    public Iterable<PsiUsesStatement> getUses() {
        PsiJavaModuleStub stub = (PsiJavaModuleStub)this.getGreenStub();
        if (stub != null) {
            return JBIterable.of((Object[])stub.getChildrenByType(JavaElementType.USES_STATEMENT, (PsiElement[])PsiUsesStatement.EMPTY_ARRAY));
        }
        return SyntaxTraverser.psiTraverser().children((Object)this).filter(PsiUsesStatement.class);
    }

    @NotNull
    public Iterable<PsiProvidesStatement> getProvides() {
        PsiJavaModuleStub stub = (PsiJavaModuleStub)this.getGreenStub();
        if (stub != null) {
            return JBIterable.of((Object[])stub.getChildrenByType(JavaElementType.PROVIDES_STATEMENT, (PsiElement[])PsiProvidesStatement.EMPTY_ARRAY));
        }
        return SyntaxTraverser.psiTraverser().children((Object)this).filter(PsiProvidesStatement.class);
    }

    @NotNull
    public PsiJavaModuleReferenceElement getNameIdentifier() {
        return (PsiJavaModuleReferenceElement)PsiTreeUtil.getRequiredChildOfType((PsiElement)this, PsiJavaModuleReferenceElement.class);
    }

    @NotNull
    public String getName() {
        PsiJavaModuleStub stub = (PsiJavaModuleStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        return this.getNameIdentifier().getReferenceText();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        PsiJavaModuleReferenceElement newName = PsiElementFactory.SERVICE.getInstance((Project)this.getProject()).createModuleReferenceFromText(name, null);
        this.getNameIdentifier().replace((PsiElement)newName);
        return this;
    }

    public PsiModifierList getModifierList() {
        return (PsiModifierList)this.getStubOrPsiChild((IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
    }

    public boolean hasModifierProperty(@NotNull String name) {
        PsiModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.hasModifierProperty(name);
    }

    @Nullable
    public PsiDocComment getDocComment() {
        return (PsiDocComment)PsiTreeUtil.getChildOfType((PsiElement)this, PsiDocComment.class);
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    @Override
    public int getTextOffset() {
        return this.getNameIdentifier().getTextOffset();
    }

    public PsiElement getOriginalElement() {
        return (PsiElement)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            JavaPsiImplementationHelper helper = JavaPsiImplementationHelper.getInstance(this.getProject());
            PsiJavaModuleImpl result = helper != null ? helper.getOriginalModule(this) : this;
            return CachedValueProvider.Result.create((Object)((Object)result), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModule((PsiJavaModule)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public SearchScope getUseScope() {
        return ProjectScope.getProjectScope((Project)this.getProject());
    }

    public String toString() {
        return "PsiJavaModule:" + this.getName();
    }
}

