/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.ModifierFlags;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakInterner;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiModifierListImpl
extends JavaStubPsiElement<PsiModifierListStub>
implements PsiModifierList {
    private static final Map<String, IElementType> NAME_TO_KEYWORD_TYPE_MAP = new THashMap();
    private static final Map<IElementType, String> KEYWORD_TYPE_TO_NAME_MAP;
    private volatile ModifierCache myModifierCache;

    public PsiModifierListImpl(PsiModifierListStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.MODIFIER_LIST);
    }

    public PsiModifierListImpl(ASTNode node) {
        super(node);
    }

    public boolean hasModifierProperty(@NotNull String name) {
        ModifierCache modifierCache = this.myModifierCache;
        if (modifierCache == null || !modifierCache.isUpToDate()) {
            this.myModifierCache = modifierCache = this.calcModifiers();
        }
        return modifierCache.modifiers.contains(name);
    }

    private ModifierCache calcModifiers() {
        Set<String> modifiers = this.calcExplicitModifiers();
        modifiers.addAll(this.calcImplicitModifiers(modifiers));
        if (!(modifiers.contains("public") || modifiers.contains("protected") || modifiers.contains("private"))) {
            modifiers.add("packageLocal");
        }
        PsiFile file = this.getContainingFile();
        return new ModifierCache(file, PsiAugmentProvider.transformModifierProperties((PsiModifierList)this, (Project)file.getProject(), modifiers));
    }

    private Set<String> calcExplicitModifiers() {
        HashSet explicitModifiers = ContainerUtil.newHashSet();
        PsiModifierListStub stub = (PsiModifierListStub)this.getGreenStub();
        if (stub != null) {
            int mask = stub.getModifiersMask();
            for (int i = 0; i < 31; ++i) {
                int flag = 1 << i;
                if (!BitUtil.isSet((int)mask, (int)flag)) continue;
                ContainerUtil.addIfNotNull((Collection)explicitModifiers, (Object)ModifierFlags.MODIFIER_FLAG_TO_NAME_MAP.get(flag));
            }
        } else {
            for (ASTNode child : this.getNode().getChildren(null)) {
                ContainerUtil.addIfNotNull((Collection)explicitModifiers, (Object)KEYWORD_TYPE_TO_NAME_MAP.get(child.getElementType()));
            }
        }
        return explicitModifiers;
    }

    private Set<String> calcImplicitModifiers(Set<String> explicitModifiers) {
        HashSet implicitModifiers = ContainerUtil.newHashSet();
        PsiElement parent = this.getParent();
        if (parent instanceof PsiClass) {
            PsiElement grandParent = parent.getContext();
            if (grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface()) {
                Collections.addAll(implicitModifiers, "public", "static");
            }
            if (((PsiClass)parent).isInterface()) {
                implicitModifiers.add("abstract");
                if (grandParent instanceof PsiClass) {
                    implicitModifiers.add("static");
                }
            }
            if (((PsiClass)parent).isEnum()) {
                boolean hasSubClass;
                if (!(grandParent instanceof PsiFile)) {
                    implicitModifiers.add("static");
                }
                List<PsiField> fields = parent instanceof PsiExtensibleClass ? ((PsiExtensibleClass)parent).getOwnFields() : Arrays.asList(((PsiClass)parent).getFields());
                boolean bl = hasSubClass = ContainerUtil.find(fields, field -> field instanceof PsiEnumConstant && ((PsiEnumConstant)field).getInitializingClass() != null) != null;
                if (!hasSubClass) {
                    implicitModifiers.add("final");
                }
                List<PsiMethod> methods = parent instanceof PsiExtensibleClass ? ((PsiExtensibleClass)parent).getOwnMethods() : Arrays.asList(((PsiClass)parent).getMethods());
                for (PsiMethod method : methods) {
                    if (!method.hasModifierProperty("abstract")) continue;
                    implicitModifiers.add("abstract");
                    break;
                }
            }
        } else if (parent instanceof PsiMethod) {
            PsiClass aClass = ((PsiMethod)parent).getContainingClass();
            if (aClass != null && aClass.isInterface()) {
                if (!explicitModifiers.contains("private")) {
                    implicitModifiers.add("public");
                    if (!explicitModifiers.contains("default") && !explicitModifiers.contains("static")) {
                        implicitModifiers.add("abstract");
                    }
                }
            } else if (aClass != null && aClass.isEnum() && ((PsiMethod)parent).isConstructor()) {
                implicitModifiers.add("private");
            }
        } else if (parent instanceof PsiField) {
            if (parent instanceof PsiEnumConstant) {
                Collections.addAll(implicitModifiers, "public", "static", "final");
            } else {
                PsiClass aClass = ((PsiField)parent).getContainingClass();
                if (aClass != null && aClass.isInterface()) {
                    Collections.addAll(implicitModifiers, "public", "static", "final");
                }
            }
        } else if (parent instanceof PsiParameter && parent.getParent() instanceof PsiCatchSection && ((PsiParameter)parent).getType() instanceof PsiDisjunctionType) {
            Collections.addAll(implicitModifiers, "final");
        } else if (parent instanceof PsiResourceVariable) {
            Collections.addAll(implicitModifiers, "final");
        }
        return implicitModifiers;
    }

    public boolean hasExplicitModifier(@NotNull String name) {
        PsiModifierListStub stub = (PsiModifierListStub)this.getGreenStub();
        if (stub != null) {
            return BitUtil.isSet((int)stub.getModifiersMask(), (int)ModifierFlags.NAME_TO_MODIFIER_FLAG_MAP.get((Object)name));
        }
        CompositeElement tree = (CompositeElement)this.getNode();
        IElementType type2 = NAME_TO_KEYWORD_TYPE_MAP.get(name);
        return type2 != null && tree.findChildByType(type2) != null;
    }

    public void setModifierProperty(@NotNull String name, boolean value2) throws IncorrectOperationException {
        this.checkSetModifierProperty(name, value2);
        PsiElement parent = this.getParent();
        PsiElement grandParent = parent != null ? parent.getParent() : null;
        IElementType type2 = NAME_TO_KEYWORD_TYPE_MAP.get(name);
        CompositeElement treeElement = (CompositeElement)this.getNode();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            CodeEditUtil.markToReformat((ASTNode)method.getParameterList().getNode(), (boolean)true);
        }
        if (value2) {
            if (type2 == JavaTokenType.PUBLIC_KEYWORD || type2 == JavaTokenType.PRIVATE_KEYWORD || type2 == JavaTokenType.PROTECTED_KEYWORD || type2 == null) {
                if (type2 != JavaTokenType.PUBLIC_KEYWORD) {
                    this.setModifierProperty("public", false);
                }
                if (type2 != JavaTokenType.PRIVATE_KEYWORD) {
                    this.setModifierProperty("private", false);
                }
                if (type2 != JavaTokenType.PROTECTED_KEYWORD) {
                    this.setModifierProperty("protected", false);
                }
                if (type2 == null) {
                    return;
                }
            }
            if (parent instanceof PsiField && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type2 == JavaTokenType.PUBLIC_KEYWORD || type2 == JavaTokenType.STATIC_KEYWORD || type2 == JavaTokenType.FINAL_KEYWORD : (parent instanceof PsiMethod && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type2 == JavaTokenType.PUBLIC_KEYWORD || type2 == JavaTokenType.ABSTRACT_KEYWORD : (parent instanceof PsiClass && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type2 == JavaTokenType.PUBLIC_KEYWORD : parent instanceof PsiAnnotationMethod && grandParent instanceof PsiClass && ((PsiClass)grandParent).isAnnotationType() && (type2 == JavaTokenType.PUBLIC_KEYWORD || type2 == JavaTokenType.ABSTRACT_KEYWORD)))) {
                return;
            }
            if (treeElement.findChildByType(type2) == null) {
                LeafElement keyword = Factory.createSingleLeafElement((IElementType)type2, (CharSequence)name, null, (PsiManager)this.getManager());
                treeElement.addInternal((TreeElement)keyword, (ASTNode)keyword, null, null);
            }
        } else {
            if (type2 == null) {
                throw new IncorrectOperationException("Cannot reset package-private modifier.");
            }
            ASTNode child = treeElement.findChildByType(type2);
            if (child != null) {
                SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)child).delete();
            }
        }
    }

    public void checkSetModifierProperty(@NotNull String name, boolean value2) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
    }

    @NotNull
    public PsiAnnotation[] getAnnotations() {
        Object[] own = (PsiAnnotation[])this.getStubOrPsiChildren((IStubElementType)JavaStubElementTypes.ANNOTATION, PsiAnnotation.ARRAY_FACTORY);
        List ext = PsiAugmentProvider.collectAugments((PsiElement)this, PsiAnnotation.class);
        return (PsiAnnotation[])ArrayUtil.mergeArrayAndCollection((Object[])own, (Collection)ext, (ArrayFactory)PsiAnnotation.ARRAY_FACTORY);
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation((PsiAnnotationOwner)this);
        List filtered = ContainerUtil.findAll((Object[])this.getAnnotations(), annotation -> {
            PsiAnnotation.TargetType target = AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])targets);
            return target != null && target != PsiAnnotation.TargetType.UNKNOWN;
        });
        return filtered.toArray(PsiAnnotation.EMPTY_ARRAY);
    }

    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        return PsiImplUtil.findAnnotation((PsiAnnotationOwner)this, qualifiedName);
    }

    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        return (PsiAnnotation)this.addAfter((PsiElement)JavaPsiFacade.getElementFactory((Project)this.getProject()).createAnnotationFromText("@" + qualifiedName, (PsiElement)this), null);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModifierList((PsiModifierList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiModifierList:" + this.getText();
    }

    static {
        NAME_TO_KEYWORD_TYPE_MAP.put("public", JavaTokenType.PUBLIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("protected", JavaTokenType.PROTECTED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("private", JavaTokenType.PRIVATE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("static", JavaTokenType.STATIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("abstract", JavaTokenType.ABSTRACT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("final", JavaTokenType.FINAL_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("native", JavaTokenType.NATIVE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("synchronized", JavaTokenType.SYNCHRONIZED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("strictfp", JavaTokenType.STRICTFP_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("transient", JavaTokenType.TRANSIENT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("volatile", JavaTokenType.VOLATILE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("default", JavaTokenType.DEFAULT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("open", JavaTokenType.OPEN_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("transitive", JavaTokenType.TRANSITIVE_KEYWORD);
        KEYWORD_TYPE_TO_NAME_MAP = ContainerUtil.newTroveMap();
        for (String name : NAME_TO_KEYWORD_TYPE_MAP.keySet()) {
            KEYWORD_TYPE_TO_NAME_MAP.put(NAME_TO_KEYWORD_TYPE_MAP.get(name), name);
        }
    }

    private static class ModifierCache {
        static final WeakInterner<List<String>> ourInterner = new WeakInterner();
        final PsiFile file;
        final List<String> modifiers;
        final long modCount;

        ModifierCache(@NotNull PsiFile file, @NotNull Set<String> modifiers) {
            this.file = file;
            ArrayList modifierList = ContainerUtil.newArrayList(modifiers);
            Collections.sort(modifierList);
            this.modifiers = (List)ourInterner.intern((Object)modifierList);
            this.modCount = this.getModCount();
        }

        private long getModCount() {
            return this.file.getManager().getModificationTracker().getModificationCount() + this.file.getModificationStamp();
        }

        boolean isUpToDate() {
            return this.getModCount() == this.modCount;
        }
    }
}

