/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterListStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiParameterListImpl
extends JavaStubPsiElement<PsiParameterListStub>
implements PsiParameterList {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiParameterListImpl");

    public PsiParameterListImpl(@NotNull PsiParameterListStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.PARAMETER_LIST);
    }

    public PsiParameterListImpl(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiParameter[] getParameters() {
        return (PsiParameter[])this.getStubOrPsiChildren((IStubElementType)JavaStubElementTypes.PARAMETER, PsiParameter.ARRAY_FACTORY);
    }

    public int getParameterIndex(@NotNull PsiParameter parameter2) {
        LOG.assertTrue(parameter2.getParent() == this);
        return PsiImplUtil.getParameterIndex(parameter2, this);
    }

    @NotNull
    public CompositeElement getNode() {
        return (CompositeElement)super.getNode();
    }

    public int getParametersCount() {
        PsiParameterListStub stub = (PsiParameterListStub)this.getGreenStub();
        if (stub != null) {
            int count = 0;
            for (StubElement child : stub.getChildrenStubs()) {
                if (child.getStubType() != JavaStubElementTypes.PARAMETER) continue;
                ++count;
            }
            return count;
        }
        return this.getNode().countChildren(Constants.PARAMETER_BIT_SET);
    }

    public boolean isEmpty() {
        PsiParameterListStub stub = (PsiParameterListStub)this.getGreenStub();
        if (stub != null) {
            return stub.getChildrenStubs().stream().noneMatch(child -> child.getStubType() == JavaStubElementTypes.PARAMETER);
        }
        return this.getNode().findChildByType(Constants.PARAMETER_BIT_SET) == null;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitParameterList((PsiParameterList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NonNls
    public String toString() {
        return "PsiParameterList:" + this.getText();
    }
}

