/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.annotations.NotNull;

public class FormatCommentsProcessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiElement e = SourceTreeToPsiMap.treeElementToPsi((ASTNode)element);
        assert (e != null && e.isValid());
        PsiFile file = e.getContainingFile();
        Project project = e.getProject();
        if (!((JavaCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, JavaCodeStyleSettings.class)).ENABLE_JAVADOC_FORMATTING || element.getPsi().getContainingFile().getLanguage() != JavaLanguage.INSTANCE || InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(element.getPsi().getContainingFile())) {
            return range;
        }
        return FormatCommentsProcessor.formatCommentsInner(project, element, range);
    }

    @NotNull
    private static TextRange formatCommentsInner(@NotNull Project project, @NotNull ASTNode element, @NotNull TextRange markedRange) {
        TextRange resultTextRange = markedRange;
        PsiElement elementPsi = element.getPsi();
        assert (elementPsi.isValid());
        PsiFile file = elementPsi.getContainingFile();
        boolean shouldFormat = markedRange.contains(element.getTextRange());
        if (shouldFormat) {
            ASTNode rangeAnchor = elementPsi instanceof PsiDocComment ? element.getTreeParent() : element;
            TextRange before = rangeAnchor.getTextRange();
            new CommentFormatter(file).processComment(element);
            int deltaRange = rangeAnchor.getTextRange().getLength() - before.getLength();
            resultTextRange = new TextRange(markedRange.getStartOffset(), markedRange.getEndOffset() + deltaRange);
        }
        if (shouldFormat && (elementPsi instanceof PsiMethod || elementPsi instanceof PsiField || elementPsi instanceof PsiDocComment) || markedRange.getEndOffset() < element.getStartOffset()) {
            return resultTextRange;
        }
        for (ASTNode current = element.getFirstChildNode(); current != null; current = current.getTreeNext()) {
            if (shouldFormat && current.getPsi() instanceof PsiDocComment && elementPsi instanceof PsiClass) continue;
            resultTextRange = FormatCommentsProcessor.formatCommentsInner(project, current, resultTextRange);
        }
        return resultTextRange;
    }
}

