/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDParser;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentFormatter {
    private static final Logger LOG = Logger.getInstance(CommentFormatter.class);
    private final CodeStyleSettings mySettings;
    private final JDParser myParser;
    private final Project myProject;

    @Deprecated
    public CommentFormatter(@NotNull Project project) {
        this.mySettings = CodeStyle.getSettings((Project)project);
        this.myParser = new JDParser(this.mySettings);
        this.myProject = project;
    }

    public CommentFormatter(@NotNull PsiFile file) {
        this.mySettings = CodeStyle.getSettings((PsiFile)file);
        this.myParser = new JDParser(this.mySettings);
        this.myProject = file.getProject();
    }

    public JavaCodeStyleSettings getSettings() {
        return (JavaCodeStyleSettings)this.mySettings.getCustomSettings(JavaCodeStyleSettings.class);
    }

    public JDParser getParser() {
        return this.myParser;
    }

    public void processComment(@Nullable ASTNode element) {
        if (!this.getSettings().ENABLE_JAVADOC_FORMATTING) {
            return;
        }
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi((ASTNode)element);
        if (psiElement != null) {
            this.getParser().formatCommentText(psiElement, this);
        }
    }

    public void replaceCommentText(@Nullable String newCommentText, @Nullable PsiDocComment oldComment) {
        if (newCommentText != null) {
            newCommentText = CommentFormatter.stripSpaces(newCommentText);
        }
        if (newCommentText == null || oldComment == null || newCommentText.equals(oldComment.getText())) {
            return;
        }
        try {
            PsiComment newComment = JavaPsiFacade.getElementFactory((Project)this.myProject).createCommentFromText(newCommentText, null);
            ASTNode oldNode = oldComment.getNode();
            ASTNode newNode = newComment.getNode();
            assert (oldNode != null && newNode != null);
            ASTNode parent = oldNode.getTreeParent();
            parent.replaceChild(oldNode, newNode);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static String stripSpaces(String text2) {
        String[] lines = LineTokenizer.tokenize((char[])text2.toCharArray(), (boolean)false);
        StringBuilder buf = new StringBuilder(text2.length());
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                buf.append('\n');
            }
            buf.append(CommentFormatter.rTrim(lines[i]));
        }
        return buf.toString();
    }

    private static String rTrim(String text2) {
        int idx;
        for (idx = text2.length(); idx > 0 && Character.isWhitespace(text2.charAt(idx - 1)); --idx) {
        }
        return text2.substring(0, idx);
    }

    private int getIndentSpecial(@NotNull PsiElement element) {
        if (!(element instanceof PsiMember)) {
            return 0;
        }
        int indentSize = this.mySettings.getIndentSize((FileType)JavaFileType.INSTANCE);
        boolean doNotIndentTopLevelClassMembers = this.mySettings.getCommonSettings((Language)JavaLanguage.INSTANCE).DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS;
        int indent = 0;
        PsiClass top = PsiUtil.getTopLevelClass((PsiElement)element);
        while (!(top == null || element.isEquivalentTo((PsiElement)top) || doNotIndentTopLevelClassMembers && element.getParent().isEquivalentTo((PsiElement)top))) {
            element = element.getParent();
            indent += indentSize;
        }
        return indent;
    }

    @NotNull
    public String getIndent(@NotNull PsiElement element) {
        return StringUtil.repeatSymbol((char)' ', (int)this.getIndentSpecial(element));
    }
}

