/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.formatting.IndentInfo;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDComment {
    protected final CommentFormatter myFormatter;
    private String myDescription;
    private List<String> myUnknownList;
    private List<String> mySeeAlsoList;
    private List<String> mySinceList;
    private String myDeprecated;
    private boolean myMultiLineComment;
    private String myFirstLine = "/**";
    private String myEndLine = "*/";

    public JDComment(@NotNull CommentFormatter formatter) {
        this.myFormatter = formatter;
    }

    protected static boolean isNull(@Nullable String s) {
        return s == null || s.trim().isEmpty();
    }

    protected static boolean isNull(@Nullable List<?> l) {
        return l == null || l.isEmpty();
    }

    public void setMultiLine(boolean value2) {
        this.myMultiLineComment = value2;
    }

    @NotNull
    protected String javadocContinuationIndent() {
        if (!this.myFormatter.getSettings().JD_INDENT_ON_CONTINUATION) {
            return "";
        }
        return this.continuationIndent();
    }

    @NotNull
    protected String continuationIndent() {
        CodeStyleSettings settings = this.myFormatter.getSettings().getContainer();
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)JavaFileType.INSTANCE);
        return new IndentInfo(0, indentOptions.CONTINUATION_INDENT_SIZE, 0).generateNewWhiteSpace(indentOptions);
    }

    @Nullable
    public String generate(@NotNull String indent) {
        StringBuilder tagDescription;
        JDTag tag;
        String prefix = this.myFormatter.getSettings().JD_LEADING_ASTERISKS_ARE_ENABLED ? indent + " * " : indent;
        StringBuilder sb = new StringBuilder();
        if (!JDComment.isNull(this.myDescription)) {
            sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(this.myDescription, prefix));
            if (this.myFormatter.getSettings().JD_ADD_BLANK_AFTER_DESCRIPTION) {
                sb.append(prefix);
                sb.append('\n');
            }
        }
        this.generateSpecial(prefix, sb);
        String continuationPrefix = prefix + this.javadocContinuationIndent();
        if (!JDComment.isNull(this.myUnknownList) && this.myFormatter.getSettings().JD_KEEP_INVALID_TAGS) {
            for (String string : this.myUnknownList) {
                sb.append((CharSequence)this.myFormatter.getParser().formatJDTagDescription(string, prefix, continuationPrefix));
            }
        }
        if (!JDComment.isNull(this.mySeeAlsoList)) {
            tag = JDTag.SEE;
            for (String aSeeAlsoList : this.mySeeAlsoList) {
                tagDescription = this.myFormatter.getParser().formatJDTagDescription(aSeeAlsoList, prefix + tag.getWithEndWhitespace(), continuationPrefix);
                sb.append((CharSequence)tagDescription);
            }
        }
        if (!JDComment.isNull(this.mySinceList)) {
            tag = JDTag.SINCE;
            for (String since : this.mySinceList) {
                tagDescription = this.myFormatter.getParser().formatJDTagDescription(since, prefix + tag.getWithEndWhitespace(), continuationPrefix);
                sb.append((CharSequence)tagDescription);
            }
        }
        if (this.myDeprecated != null) {
            tag = JDTag.DEPRECATED;
            StringBuilder stringBuilder = this.myFormatter.getParser().formatJDTagDescription(this.myDeprecated, prefix + tag.getWithEndWhitespace(), continuationPrefix);
            sb.append((CharSequence)stringBuilder);
        }
        if (sb.length() > prefix.length()) {
            int nlen = sb.length() - prefix.length() - 1;
            if (sb.substring(nlen, sb.length()).equals(prefix + "\n")) {
                sb.delete(nlen, sb.length());
            }
        } else if (sb.length() == 0 && !StringUtil.isEmpty((String)this.myEndLine)) {
            sb.append('\n').append('*').append('\n');
        }
        if (this.myMultiLineComment && this.myFormatter.getSettings().JD_DO_NOT_WRAP_ONE_LINE_COMMENTS || !this.myFormatter.getSettings().JD_DO_NOT_WRAP_ONE_LINE_COMMENTS || sb.indexOf("\n") != sb.length() - 1) {
            sb.insert(0, this.myFirstLine + '\n');
            sb.append(indent);
        } else {
            sb.replace(0, prefix.length(), this.myFirstLine + " ");
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(' ').append(this.myEndLine);
        return sb.toString();
    }

    protected void generateSpecial(@NotNull String prefix, @NotNull StringBuilder sb) {
    }

    public void setFirstCommentLine(@NotNull String firstCommentLine) {
        this.myFirstLine = firstCommentLine;
    }

    public void setLastCommentLine(@NotNull String lastCommentLine) {
        this.myEndLine = lastCommentLine;
    }

    public void addSeeAlso(@NotNull String seeAlso) {
        if (this.mySeeAlsoList == null) {
            this.mySeeAlsoList = new ArrayList<String>();
        }
        this.mySeeAlsoList.add(seeAlso);
    }

    public void addUnknownTag(@NotNull String unknownTag) {
        if (this.myUnknownList == null) {
            this.myUnknownList = new ArrayList<String>();
        }
        this.myUnknownList.add(unknownTag);
    }

    public void addSince(@NotNull String since) {
        if (this.mySinceList == null) {
            this.mySinceList = new ArrayList<String>();
        }
        this.mySinceList.add(since);
    }

    public void setDeprecated(@Nullable String deprecated) {
        this.myDeprecated = deprecated;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = description;
    }
}

