/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.javadoc;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDComment;
import com.intellij.psi.impl.source.codeStyle.javadoc.JDTag;
import com.intellij.psi.impl.source.codeStyle.javadoc.TagDescription;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDParamListOwnerComment
extends JDComment {
    protected List<TagDescription> myParamsList;

    public JDParamListOwnerComment(@NotNull CommentFormatter formatter) {
        super(formatter);
    }

    @Override
    protected void generateSpecial(@NotNull String prefix, @NotNull StringBuilder sb) {
        if (this.myParamsList != null) {
            int before = sb.length();
            this.generateList(prefix, sb, this.myParamsList, JDTag.PARAM.getWithEndWhitespace(), this.myFormatter.getSettings().JD_ALIGN_PARAM_COMMENTS, this.myFormatter.getSettings().JD_KEEP_EMPTY_PARAMETER, this.myFormatter.getSettings().JD_PARAM_DESCRIPTION_ON_NEW_LINE);
            int size = sb.length() - before;
            if (size > 0 && this.myFormatter.getSettings().JD_ADD_BLANK_AFTER_PARM_COMMENTS) {
                sb.append(prefix);
                sb.append('\n');
            }
        }
    }

    @Nullable
    public TagDescription getParameter(@Nullable String name) {
        return JDParamListOwnerComment.getNameDesc(name, this.myParamsList);
    }

    public void addParameter(@NotNull String name, @Nullable String description) {
        if (this.myParamsList == null) {
            this.myParamsList = ContainerUtilRt.newArrayList();
        }
        this.myParamsList.add(new TagDescription(name, description));
    }

    @Nullable
    private static TagDescription getNameDesc(@Nullable String name, @Nullable List<TagDescription> list) {
        if (list == null) {
            return null;
        }
        for (TagDescription aList : list) {
            if (!aList.name.equals(name)) continue;
            return aList;
        }
        return null;
    }

    protected void generateList(@NotNull String prefix, @NotNull StringBuilder sb, @NotNull List<? extends TagDescription> tagBlocks, @NotNull String tag, boolean align_comments, boolean generate_empty_tags, boolean descriptionOnNewLine) {
        int maxNameLength = JDParamListOwnerComment.maxTagDescriptionNameLength(tagBlocks, align_comments, generate_empty_tags, descriptionOnNewLine);
        StringBuilder fill = new StringBuilder(prefix.length() + tag.length() + maxNameLength + 1);
        fill.append(prefix);
        StringUtil.repeatSymbol((Appendable)fill, (char)' ', (int)(maxNameLength + 1 + tag.length()));
        for (TagDescription tagDescription : tagBlocks) {
            if (JDParamListOwnerComment.isNull(tagDescription.desc) && !generate_empty_tags) continue;
            if (descriptionOnNewLine && !JDParamListOwnerComment.isNull(tagDescription.desc)) {
                sb.append(prefix).append(tag).append(tagDescription.name).append("\n");
                sb.append((CharSequence)this.formatJDTagDescription(tagDescription.desc, prefix + this.continuationIndent()));
                continue;
            }
            if (align_comments) {
                int spacesNumber = maxNameLength + 1 - tagDescription.name.length();
                String spaces = StringUtil.repeatSymbol((char)' ', (int)Math.max(0, spacesNumber));
                String firstLinePrefix = prefix + tag + tagDescription.name + spaces;
                sb.append((CharSequence)this.formatJDTagDescription(tagDescription.desc, firstLinePrefix, fill));
                continue;
            }
            String description = tagDescription.desc == null ? "" : tagDescription.desc;
            StringBuilder tagDescription2 = this.formatJDTagDescription(tag + tagDescription.name + " " + description, prefix, prefix + this.javadocContinuationIndent());
            sb.append((CharSequence)tagDescription2);
        }
    }

    private static int maxTagDescriptionNameLength(@NotNull List<? extends TagDescription> tagBlocks, boolean align_comments, boolean generate_empty_tags, boolean descriptionOnNewLine) {
        int max = 0;
        if (align_comments && !descriptionOnNewLine) {
            for (TagDescription tagDescription : tagBlocks) {
                int current = tagDescription.name.length();
                if (JDParamListOwnerComment.isNull(tagDescription.desc) && !generate_empty_tags || current <= max) continue;
                max = current;
            }
        }
        return max;
    }

    private StringBuilder formatJDTagDescription(@Nullable String description, @NotNull CharSequence firstLinePrefix, @NotNull CharSequence continuationPrefix) {
        return this.myFormatter.getParser().formatJDTagDescription(description, firstLinePrefix, continuationPrefix);
    }

    private StringBuilder formatJDTagDescription(@Nullable String description, @NotNull CharSequence prefix) {
        return this.formatJDTagDescription(description, prefix, prefix);
    }
}

