/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaResolveCache {
    private static final NotNullLazyKey<JavaResolveCache, Project> INSTANCE_KEY = ServiceManager.createLazyKey(JavaResolveCache.class);
    private final AtomicReference<ConcurrentMap<PsiExpression, PsiType>> myCalculatedTypes = new AtomicReference();
    private final AtomicReference<Map<PsiVariable, Object>> myVarToConstValueMapPhysical = new AtomicReference();
    private final AtomicReference<Map<PsiVariable, Object>> myVarToConstValueMapNonPhysical = new AtomicReference();
    private static final Object NULL = Key.create((String)"NULL");

    public static JavaResolveCache getInstance(Project project) {
        return (JavaResolveCache)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    public JavaResolveCache(@Nullable(value="can be null in com.intellij.core.JavaCoreApplicationEnvironment.JavaCoreApplicationEnvironment") MessageBus messageBus) {
        if (messageBus != null) {
            messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener.Adapter(){

                public void beforePsiChanged(boolean isPhysical) {
                    JavaResolveCache.this.clearCaches(isPhysical);
                }
            });
        }
    }

    private void clearCaches(boolean isPhysical) {
        this.myCalculatedTypes.set(null);
        if (isPhysical) {
            this.myVarToConstValueMapPhysical.set(null);
        }
        this.myVarToConstValueMapNonPhysical.set(null);
    }

    @Nullable
    public <T extends PsiExpression> PsiType getType(@NotNull T expr, @NotNull Function<T, PsiType> f) {
        PsiType type2;
        boolean isOverloadCheck = MethodCandidateInfo.isOverloadCheck() || LambdaUtil.isLambdaParameterCheck();
        boolean polyExpression = PsiPolyExpressionUtil.isPolyExpression(expr);
        ConcurrentMap map2 = this.myCalculatedTypes.get();
        if (map2 == null) {
            map2 = (ConcurrentMap)ConcurrencyUtil.cacheOrGet(this.myCalculatedTypes, (Object)ContainerUtil.createConcurrentWeakKeySoftValueMap());
        }
        PsiType psiType = type2 = isOverloadCheck && polyExpression ? null : (PsiType)map2.get(expr);
        if (type2 == null) {
            RecursionGuard.StackStamp dStackStamp = PsiDiamondType.ourDiamondGuard.markStack();
            type2 = (PsiType)f.fun(expr);
            if (!dStackStamp.mayCacheNow()) {
                return type2;
            }
            if (isOverloadCheck && polyExpression) {
                return type2;
            }
            if (type2 == null) {
                type2 = TypeConversionUtil.NULL_TYPE;
            }
            map2.put(expr, type2);
            if (type2 instanceof PsiClassReferenceType) {
                PsiClassType.ClassResolveResult result = ((PsiClassReferenceType)type2).resolveGenerics();
                PsiClass psiClass = result.getElement();
                type2 = psiClass == null ? type2 : new PsiImmediateClassType(psiClass, result.getSubstitutor(), ((PsiClassReferenceType)type2).getLanguageLevel(), type2.getAnnotationProvider());
            }
        }
        return type2 == TypeConversionUtil.NULL_TYPE ? null : type2;
    }

    @Nullable
    public Object computeConstantValueWithCaching(@NotNull PsiVariable variable, @NotNull ConstValueComputer computer, Set<PsiVariable> visitedVars) {
        Object cached;
        boolean physical = variable.isPhysical();
        AtomicReference<Map<PsiVariable, Object>> ref = physical ? this.myVarToConstValueMapPhysical : this.myVarToConstValueMapNonPhysical;
        Map map2 = ref.get();
        if (map2 == null) {
            map2 = (Map)ConcurrencyUtil.cacheOrGet(ref, (Object)ContainerUtil.createConcurrentWeakMap());
        }
        if ((cached = map2.get(variable)) == NULL) {
            return null;
        }
        if (cached != null) {
            return cached;
        }
        Object result = computer.execute(variable, visitedVars);
        map2.put(variable, result == null ? NULL : result);
        return result;
    }

    @FunctionalInterface
    public static interface ConstValueComputer {
        public Object execute(@NotNull PsiVariable var1, Set<PsiVariable> var2);
    }
}

