/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.CompoundInitialState;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.InitialInferenceState;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceSessionContainer {
    private static final Logger LOG = Logger.getInstance(InferenceSessionContainer.class);
    private final Map<PsiElement, InferenceSession> myNestedSessions = new HashMap<PsiElement, InferenceSession>();

    InferenceSessionContainer() {
    }

    public void registerNestedSession(InferenceSession session) {
        this.myNestedSessions.put(session.getContext(), session);
        this.myNestedSessions.putAll(session.getInferenceSessionContainer().myNestedSessions);
    }

    @Contract(value="_, !null -> !null")
    public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
        InferenceSession session = this.myNestedSessions.get(PsiTreeUtil.getParentOfType((PsiElement)arg, PsiCall.class));
        return session == null ? defaultSession : session.getInferenceSubstitution();
    }

    void registerNestedSession(InferenceSession session, PsiType returnType, PsiExpression returnExpression2) {
        InferenceSession inferenceSession;
        PsiSubstitutor callSession = this.findNestedSubstitutor((PsiElement)((PsiCallExpression)returnExpression2).getArgumentList(), null);
        if (callSession == null && (inferenceSession = ExpressionCompatibilityConstraint.reduceExpressionCompatibilityConstraint(session, returnExpression2, returnType, false)) != null && inferenceSession != session) {
            this.registerNestedSession(inferenceSession);
            session.propagateVariables(inferenceSession);
        }
    }

    static PsiSubstitutor infer(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        PsiCall topLevelCall;
        PsiExpressionList argumentList;
        MethodCandidateInfo.CurrentCandidateProperties properties;
        if (parent instanceof PsiCall && (properties = MethodCandidateInfo.getCurrentMethod((PsiElement)(argumentList = ((PsiCall)parent).getArgumentList()))) != null && !properties.isApplicabilityCheck() && !MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argumentList) && (topLevelCall = (PsiCall)PsiResolveHelper.ourGraphGuard.doPreventingRecursion((Object)parent, false, () -> {
            if (parent instanceof PsiExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)((PsiExpression)parent))) {
                return null;
            }
            return LambdaUtil.treeWalkUp((PsiElement)parent);
        })) != null) {
            InferenceSession session;
            if (MethodCandidateInfo.isOverloadCheck() || !PsiDiamondType.ourDiamondGuard.currentStack().isEmpty() || LambdaUtil.isLambdaParameterCheck() || !policy.equals(DefaultParameterTypeInferencePolicy.INSTANCE)) {
                session = InferenceSessionContainer.startTopLevelInference(topLevelCall, policy);
            } else {
                Map<PsiElement, InferenceSession> sessions;
                InferenceSession childSession;
                session = (InferenceSession)CachedValuesManager.getCachedValue((PsiElement)topLevelCall, () -> new CachedValueProvider.Result((Object)InferenceSessionContainer.startTopLevelInference(topLevelCall, (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
                if (session != null && (childSession = (sessions = session.getInferenceSessionContainer().myNestedSessions).get(parent)) != null) {
                    for (PsiTypeParameter parameter2 : typeParameters) {
                        if (childSession.getInferenceSubstitution().getSubstitutionMap().containsKey(parameter2)) continue;
                        session = InferenceSessionContainer.startTopLevelInference(topLevelCall, policy);
                        break;
                    }
                }
            }
            if (session != null) {
                PsiSubstitutor childSubstitutor = InferenceSessionContainer.inferNested(parameters2, arguments, (PsiCall)parent, properties, session);
                if (childSubstitutor != null) {
                    return childSubstitutor;
                }
            } else if (topLevelCall instanceof PsiMethodCallExpression) {
                return new InferenceSession(typeParameters, partialSubstitutor, parent.getManager(), parent, policy).prepareSubstitution();
            }
        }
        InferenceSession inferenceSession = new InferenceSession(typeParameters, partialSubstitutor, parent.getManager(), parent, policy);
        inferenceSession.initExpressionConstraints(parameters2, arguments, parent);
        return inferenceSession.infer(parameters2, arguments, parent);
    }

    private static PsiSubstitutor inferNested(@NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments, @NotNull PsiCall parent, @NotNull MethodCandidateInfo.CurrentCandidateProperties properties, @NotNull InferenceSession parentSession) {
        CompoundInitialState compoundInitialState = InferenceSessionContainer.createState(parentSession);
        InitialInferenceState initialInferenceState = compoundInitialState.getInitialState(parent);
        if (initialInferenceState != null) {
            InferenceSession childSession = new InferenceSession(initialInferenceState);
            List<String> errorMessages = parentSession.getIncompatibleErrorMessages();
            if (errorMessages != null) {
                PsiMethod outerCallerMethod;
                PsiElement context = parentSession.getContext();
                if (context instanceof PsiCallExpression && (outerCallerMethod = ((PsiCallExpression)context).resolveMethod()) != null && outerCallerMethod.hasTypeParameters()) {
                    return properties.getInfo().getSubstitutor(false);
                }
                return null;
            }
            return childSession.collectAdditionalAndInfer(parameters2, arguments, properties, compoundInitialState.getInitialSubstitutor());
        }
        PsiElement gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
        while (true) {
            PsiCall call;
            PsiElement returnContainer;
            if (gParent instanceof PsiReturnStatement && (returnContainer = gParent.getParent()) instanceof PsiCodeBlock) {
                gParent = returnContainer.getParent();
            }
            if (gParent instanceof PsiConditionalExpression) {
                gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)gParent.getParent());
            }
            if (!(gParent instanceof PsiLambdaExpression) || (call = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)gParent, PsiCall.class)) == null) break;
            initialInferenceState = compoundInitialState.getInitialState(call);
            if (initialInferenceState != null) {
                PsiExpressionList argumentList = call.getArgumentList();
                int idx = LambdaUtil.getLambdaIdx((PsiExpressionList)argumentList, (PsiElement)gParent);
                JavaResolveResult result = PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)call);
                PsiElement method = result.getElement();
                if (!(method instanceof PsiMethod) || idx <= -1) break;
                LOG.assertTrue(argumentList != null);
                PsiParameter[] methodParameters = ((PsiMethod)method).getParameterList().getParameters();
                if (methodParameters.length == 0) break;
                InferenceSession sessionInsideLambda = new InferenceSession(initialInferenceState);
                sessionInsideLambda.collectAdditionalAndInfer(methodParameters, argumentList.getExpressions(), ((MethodCandidateInfo)result).createProperties(), compoundInitialState.getInitialSubstitutor());
                return InferenceSessionContainer.inferNested(parameters2, arguments, parent, properties, sessionInsideLambda);
            }
            gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
        }
        return null;
    }

    private static CompoundInitialState createState(InferenceSession topLevelSession) {
        PsiSubstitutor topInferenceSubstitutor = InferenceSessionContainer.replaceVariables(topLevelSession.getInferenceVariables());
        final LinkedHashMap<PsiElement, InitialInferenceState> nestedStates = new LinkedHashMap<PsiElement, InitialInferenceState>();
        InferenceSessionContainer copy = new InferenceSessionContainer(){

            @Override
            public PsiSubstitutor findNestedSubstitutor(PsiElement arg, @Nullable PsiSubstitutor defaultSession) {
                PsiSubstitutor substitutor = super.findNestedSubstitutor(arg, null);
                if (substitutor != null) {
                    return substitutor;
                }
                InitialInferenceState state = (InitialInferenceState)nestedStates.get(PsiTreeUtil.getParentOfType((PsiElement)arg, PsiCall.class));
                if (state != null) {
                    return state.getInferenceSubstitutor();
                }
                return super.findNestedSubstitutor(arg, defaultSession);
            }
        };
        Map<PsiElement, InferenceSession> nestedSessions = topLevelSession.getInferenceSessionContainer().myNestedSessions;
        for (Map.Entry<PsiElement, InferenceSession> entry : nestedSessions.entrySet()) {
            nestedStates.put(entry.getKey(), entry.getValue().createInitialState(copy, topLevelSession.getInferenceVariables(), topInferenceSubstitutor));
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : topLevelSession.getInferenceVariables()) {
            PsiClass psiClass;
            PsiType instantiation = variable.getInstantiation();
            if (instantiation == PsiType.NULL || !((psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)topInferenceSubstitutor.substitute((PsiTypeParameter)variable))) instanceof InferenceVariable)) continue;
            substitutor = substitutor.put((PsiTypeParameter)psiClass, instantiation);
        }
        return new CompoundInitialState(substitutor, nestedStates);
    }

    @Nullable
    private static InferenceSession startTopLevelInference(PsiCall topLevelCall, ParameterTypeInferencePolicy policy) {
        JavaResolveResult result = PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)topLevelCall);
        if (result instanceof MethodCandidateInfo) {
            PsiMethod method = ((MethodCandidateInfo)result).getElement();
            PsiParameter[] topLevelParameters = method.getParameterList().getParameters();
            PsiExpressionList topLevelCallArgumentList = topLevelCall.getArgumentList();
            LOG.assertTrue(topLevelCallArgumentList != null, (Object)topLevelCall);
            PsiExpression[] topLevelArguments = topLevelCallArgumentList.getExpressions();
            return (InferenceSession)PsiResolveHelper.ourGraphGuard.doPreventingRecursion((Object)topLevelCall, true, () -> {
                InferenceSession topLevelSession = new InferenceSession(method.getTypeParameters(), ((MethodCandidateInfo)result).getSiteSubstitutor(), topLevelCall.getManager(), (PsiElement)topLevelCall, policy);
                topLevelSession.initExpressionConstraints(topLevelParameters, topLevelArguments, (PsiElement)topLevelCall, method, ((MethodCandidateInfo)result).isVarargs());
                topLevelSession.infer(topLevelParameters, topLevelArguments, (PsiElement)topLevelCall, ((MethodCandidateInfo)result).createProperties());
                return topLevelSession;
            });
        }
        return null;
    }

    @NotNull
    private static PsiSubstitutor replaceVariables(Collection<InferenceVariable> inferenceVariables) {
        InferenceVariable[] oldVars;
        ArrayList<InferenceVariable> targetVars = new ArrayList<InferenceVariable>();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (InferenceVariable variable : oldVars = inferenceVariables.toArray(new InferenceVariable[0])) {
            InferenceVariable newVariable = new InferenceVariable(variable.getCallContext(), variable.getParameter(), variable.getName());
            substitutor = substitutor.put((PsiTypeParameter)variable, (PsiType)JavaPsiFacade.getElementFactory((Project)variable.getProject()).createType((PsiClass)newVariable));
            targetVars.add(newVariable);
            if (variable.isThrownBound()) {
                newVariable.setThrownBound();
            }
            newVariable.putUserData(InferenceSession.ORIGINAL_CAPTURE, variable.getUserData(InferenceSession.ORIGINAL_CAPTURE));
        }
        for (int i = 0; i < targetVars.size(); ++i) {
            InferenceVariable var = (InferenceVariable)((Object)targetVars.get(i));
            for (InferenceBound boundType : InferenceBound.values()) {
                for (PsiType bound : oldVars[i].getBounds(boundType)) {
                    var.addBound(substitutor.substitute(bound), boundType, null);
                }
            }
        }
        return substitutor;
    }
}

