/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.TypeAnnotationModifier;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceIncorporationPhase;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferenceVariable
extends LightTypeParameter {
    private final PsiElement myContext;
    private boolean myThrownBound;
    private final Map<InferenceBound, List<PsiType>> myBounds = new EnumMap<InferenceBound, List<PsiType>>(InferenceBound.class);
    private final String myName;
    private PsiType myInstantiation = PsiType.NULL;

    public PsiTypeParameter getParameter() {
        return this.getDelegate();
    }

    InferenceVariable(PsiElement context, PsiTypeParameter parameter2, String name) {
        super(parameter2);
        this.myName = name;
        this.myContext = context;
        TypeConversionUtil.markAsFreshVariable((PsiTypeParameter)this, (PsiElement)context);
    }

    public PsiType getInstantiation() {
        return this.myInstantiation;
    }

    public void setInstantiation(PsiType instantiation) {
        this.myInstantiation = instantiation;
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
        for (PsiType type2 : this.getBounds(InferenceBound.UPPER)) {
            if (!(type2 instanceof PsiClassType)) continue;
            result.add((PsiClassType)type2);
        }
        return result.toArray(PsiClassType.EMPTY_ARRAY);
    }

    public static void addBound(PsiType inferenceVariableType, PsiType boundType, InferenceBound inferenceBound, InferenceSession session) {
        InferenceVariable variable = session.getInferenceVariable(inferenceVariableType);
        if (variable != null) {
            boundType = InferenceVariable.modifyAnnotations(boundType, (b, modifier) -> modifier.boundAppeared(inferenceVariableType, b));
            variable.addBound(boundType, inferenceBound, session.myIncorporationPhase);
        }
    }

    static PsiType modifyAnnotations(PsiType type2, BiFunction<? super PsiType, ? super TypeAnnotationModifier, ? extends TypeAnnotationProvider> executeModifier) {
        for (TypeAnnotationModifier modifier : (TypeAnnotationModifier[])TypeAnnotationModifier.EP_NAME.getExtensions()) {
            TypeAnnotationProvider annotationProvider;
            if (!(type2 instanceof PsiClassType) || (annotationProvider = executeModifier.apply((PsiType)type2, (TypeAnnotationModifier)modifier)) == null) continue;
            type2 = type2.annotate(annotationProvider);
        }
        return type2;
    }

    boolean addBound(PsiType classType, InferenceBound inferenceBound, @Nullable InferenceIncorporationPhase incorporationPhase) {
        if (PsiUtil.resolveClassInClassTypeOnly((PsiType)classType) == this) {
            return false;
        }
        List bounds = this.myBounds.computeIfAbsent(inferenceBound, __ -> new ArrayList());
        if (classType == null) {
            classType = PsiType.NULL;
        }
        if (incorporationPhase == null || !bounds.contains(classType)) {
            bounds.add(classType);
            if (incorporationPhase != null) {
                incorporationPhase.addBound(this, classType, inferenceBound);
            }
            return true;
        }
        return false;
    }

    public List<PsiType> getBounds(InferenceBound inferenceBound) {
        List<PsiType> bounds = this.myBounds.get((Object)inferenceBound);
        return bounds != null ? new ArrayList<PsiType>(bounds) : Collections.emptyList();
    }

    public Set<InferenceVariable> getDependencies(InferenceSession session) {
        LinkedHashSet<InferenceVariable> dependencies = new LinkedHashSet<InferenceVariable>();
        this.collectBoundDependencies(session, dependencies);
        this.collectTransitiveDependencies(session, dependencies, dependencies);
        if (!session.hasCapture(this) && dependencies.isEmpty()) {
            return dependencies;
        }
        if (!session.hasCapture(this)) {
            return dependencies;
        }
        dependencies.removeIf(variable -> !session.hasCapture((InferenceVariable)((Object)variable)));
        session.collectCaptureDependencies(this, dependencies);
        return dependencies;
    }

    private void collectTransitiveDependencies(InferenceSession session, Set<? extends InferenceVariable> dependencies, Set<? super InferenceVariable> rootDependencies) {
        LinkedHashSet newDependencies = new LinkedHashSet();
        for (InferenceVariable inferenceVariable : dependencies) {
            inferenceVariable.collectBoundDependencies(session, newDependencies);
        }
        newDependencies.removeAll(rootDependencies);
        newDependencies.remove((Object)this);
        if (!newDependencies.isEmpty()) {
            rootDependencies.addAll(newDependencies);
            this.collectTransitiveDependencies(session, newDependencies, rootDependencies);
        }
    }

    private void collectBoundDependencies(InferenceSession session, Set<? super InferenceVariable> dependencies) {
        for (Collection collection : this.myBounds.values()) {
            if (collection == null) continue;
            for (PsiType bound : collection) {
                session.collectDependencies(bound, dependencies);
            }
        }
    }

    boolean isThrownBound() {
        return this.myThrownBound;
    }

    public void setThrownBound() {
        this.myThrownBound = true;
    }

    @Override
    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        for (PsiType type2 : this.getBounds(InferenceBound.UPPER)) {
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
            if (psiClass == null) continue;
            if (this.getManager().areElementsEquivalent((PsiElement)baseClass, (PsiElement)psiClass)) {
                return true;
            }
            if (!checkDeep || !psiClass.isInheritor(baseClass, true)) continue;
            return true;
        }
        return super.isInheritor(baseClass, checkDeep);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }

    @Override
    public boolean useDelegateToSubstitute() {
        return false;
    }

    @Override
    public String toString() {
        return this.getDelegate().toString();
    }

    @Override
    public PsiTypeParameterListOwner getOwner() {
        return null;
    }

    @Override
    @Nullable
    public String getName() {
        return this.myName;
    }

    PsiElement getCallContext() {
        return this.myContext;
    }
}

