/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.GenericReferenceProvider;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericReference
extends CachingReference
implements EmptyResolveMessageProvider {
    public static final GenericReference[] EMPTY_ARRAY = new GenericReference[0];
    @Nullable
    private final GenericReferenceProvider myProvider;

    public GenericReference(GenericReferenceProvider provider) {
        this.myProvider = provider;
    }

    public void processVariants(PsiScopeProcessor processor) {
        PsiElement context = this.getContext();
        if (context != null) {
            context.processDeclarations(processor, ResolveState.initial(), this.getElement(), this.getElement());
        } else if (this.getContextReference() == null && this.myProvider != null) {
            this.myProvider.handleEmptyContext(processor, this.getElement());
        }
    }

    @Nullable
    public PsiElement handleElementRename(@NotNull String string) throws IncorrectOperationException {
        ElementManipulator man;
        PsiElement element = this.getElement();
        if (element != null && (man = ElementManipulators.getManipulator((PsiElement)element)) != null) {
            return man.handleContentChange(element, this.getRangeInElement(), string);
        }
        return element;
    }

    @Nullable
    public PsiReferenceProvider getProvider() {
        return this.myProvider;
    }

    @Nullable
    public abstract PsiElement getContext();

    @Nullable
    public abstract PsiReference getContextReference();
}

