/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaLangClassMemberReference;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaLangInvokeHandleReference;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaReflectionReferenceContributor
extends PsiReferenceContributor {
    public static final PsiJavaElementPattern.Capture<PsiLiteral> PATTERN = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiLiteral().methodCallParameter((ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(new String[]{"getField", "getDeclaredField", "getMethod", "getDeclaredMethod"})).definedInClass("java.lang.Class"));
    public static final PsiJavaElementPattern.Capture<PsiLiteral> CLASS_PATTERN = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiLiteral().methodCallParameter(0, StandardPatterns.or((ElementPattern[])new ElementPattern[]{((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("forName")).definedInClass("java.lang.Class"), ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("loadClass")).definedInClass("java.lang.ClassLoader"), ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("findClass")).definedInClass("java.lang.invoke.MethodHandles.Lookup")}));
    private static final ElementPattern<? extends PsiElement> METHOD_HANDLE_PATTERN = PsiJavaPatterns.psiLiteral().methodCallParameter(1, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(JavaReflectionReferenceUtil.HANDLE_FACTORY_METHOD_NAMES)).definedInClass("java.lang.invoke.MethodHandles.Lookup"));
    public static final PsiJavaElementPattern.Capture<PsiLiteral> ATOMIC_NUMERIC_PATTERN = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiLiteral().methodCallParameter(1, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("newUpdater")).definedInClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"java.util.concurrent.atomic.AtomicLongFieldUpdater", "java.util.concurrent.atomic.AtomicIntegerFieldUpdater"}))));
    public static final PsiJavaElementPattern.Capture<PsiLiteral> ATOMIC_REFERENCE_PATTERN = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiLiteral().methodCallParameter(2, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("newUpdater")).definedInClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName("java.util.concurrent.atomic.AtomicReferenceFieldUpdater")));

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(PATTERN, (PsiReferenceProvider)new JavaReflectionReferenceProvider(){

            @Override
            @Nullable
            protected PsiReference[] getReferencesByMethod(@NotNull PsiLiteralExpression literalArgument, @NotNull PsiReferenceExpression methodReference, @NotNull ProcessingContext context) {
                PsiReference[] psiReferenceArray;
                PsiExpression qualifier = methodReference.getQualifierExpression();
                if (qualifier != null) {
                    PsiReference[] psiReferenceArray2 = new PsiReference[1];
                    psiReferenceArray = psiReferenceArray2;
                    psiReferenceArray2[0] = new JavaLangClassMemberReference(literalArgument, qualifier);
                } else {
                    psiReferenceArray = null;
                }
                return psiReferenceArray;
            }
        });
        registrar.registerReferenceProvider(CLASS_PATTERN, (PsiReferenceProvider)new ReflectionClassNameReferenceProvider());
        registrar.registerReferenceProvider(METHOD_HANDLE_PATTERN, (PsiReferenceProvider)new JavaLangInvokeHandleReference.JavaLangInvokeHandleReferenceProvider());
        JavaReflectionReferenceProvider atomicProvider = new JavaReflectionReferenceProvider(){

            @Override
            protected PsiReference[] getReferencesByMethod(@NotNull PsiLiteralExpression literalArgument, @NotNull PsiReferenceExpression methodReference, @NotNull ProcessingContext context) {
                PsiElement parent = literalArgument.getParent();
                if (parent instanceof PsiExpressionList) {
                    PsiExpression[] arguments = ((PsiExpressionList)parent).getExpressions();
                    return new PsiReference[]{new JavaLangClassMemberReference(literalArgument, arguments[0])};
                }
                return PsiReference.EMPTY_ARRAY;
            }
        };
        registrar.registerReferenceProvider(ATOMIC_NUMERIC_PATTERN, (PsiReferenceProvider)atomicProvider);
        registrar.registerReferenceProvider(ATOMIC_REFERENCE_PATTERN, (PsiReferenceProvider)atomicProvider);
    }

    private static class ReflectionClassNameReferenceProvider
    extends JavaClassReferenceProvider {
        ReflectionClassNameReferenceProvider() {
            this.setOption(JavaClassReferenceProvider.ALLOW_DOLLAR_NAMES, Boolean.TRUE);
            this.setOption(JavaClassReferenceProvider.JVM_FORMAT, Boolean.TRUE);
        }

        @Override
        @NotNull
        public PsiReference[] getReferencesByString(String str, @NotNull PsiElement position, int offsetInPosition) {
            if (StringUtil.isEmpty((String)str)) {
                return PsiReference.EMPTY_ARRAY;
            }
            return new JavaClassReferenceSet(str, position, offsetInPosition, true, this){

                @Override
                public boolean isAllowDollarInNames() {
                    return true;
                }
            }.getAllReferences();
        }
    }
}

