/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiRawStringLiteralUtil;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class StringLiteralManipulator
extends AbstractElementManipulator<PsiLiteralExpression> {
    public PsiLiteralExpression handleContentChange(@NotNull PsiLiteralExpression expr, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String oldText = expr.getText();
        if (oldText.startsWith("\"")) {
            newContent = StringUtil.escapeStringCharacters((String)newContent);
        } else if (oldText.startsWith("'") && newContent.length() <= 1) {
            newContent = newContent.length() == 1 && newContent.charAt(0) == '\'' ? "\\'" : newContent;
        } else {
            throw new IncorrectOperationException("cannot handle content change for: " + oldText + ", expr: " + expr);
        }
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        PsiExpression newExpr = JavaPsiFacade.getElementFactory((Project)expr.getProject()).createExpressionFromText(newText, null);
        return (PsiLiteralExpression)expr.replace((PsiElement)newExpr);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull PsiLiteralExpression element) {
        return StringLiteralManipulator.getValueRange(element);
    }

    @NotNull
    public static TextRange getValueRange(@NotNull PsiLiteralExpression element) {
        boolean isQuoted;
        int length = element.getTextLength();
        if (element instanceof PsiLiteralExpressionImpl) {
            IElementType type2 = ((PsiLiteralExpressionImpl)element).getLiteralElementType();
            if (type2 == JavaTokenType.RAW_STRING_LITERAL) {
                int trailingSeq;
                String text2 = ((PsiLiteralExpressionImpl)element).getNode().getText();
                int leadingSeq = PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)text2);
                return length >= leadingSeq + (trailingSeq = PsiRawStringLiteralUtil.getTrailingTicksSequence((CharSequence)text2)) ? TextRange.from((int)leadingSeq, (int)(length - trailingSeq - leadingSeq)) : TextRange.from((int)0, (int)length);
            }
            isQuoted = type2 == JavaTokenType.STRING_LITERAL || type2 == JavaTokenType.CHARACTER_LITERAL;
        } else {
            Object value2 = element.getValue();
            isQuoted = value2 instanceof String || value2 instanceof Character;
        }
        return isQuoted ? new TextRange(1, Math.max(1, length - 1)) : TextRange.from((int)0, (int)length);
    }
}

