/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PackagePrefixFileSystemItemImpl;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePathReferenceProvider
extends PsiReferenceProvider {
    private final boolean myEndingSlashNotAllowed;

    public FilePathReferenceProvider() {
        this(true);
    }

    public FilePathReferenceProvider(boolean endingSlashNotAllowed) {
        this.myEndingSlashNotAllowed = endingSlashNotAllowed;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, String text2, int offset, boolean soft) {
        return this.getReferencesByElement(element, text2, offset, soft, Module.EMPTY_ARRAY);
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, String text2, int offset, final boolean soft, final Module ... forModules) {
        return new FileReferenceSet(text2, element, offset, this, true, this.myEndingSlashNotAllowed){

            protected boolean isSoft() {
                return soft;
            }

            public boolean isAbsolutePathReference() {
                return true;
            }

            public boolean couldBeConvertedTo(boolean relative) {
                return !relative;
            }

            public boolean absoluteUrlNeedsStartSlash() {
                String s = this.getPathString();
                return s != null && !s.isEmpty() && s.charAt(0) == '/';
            }

            @NotNull
            public Collection<PsiFileSystemItem> computeDefaultContexts() {
                if (forModules.length > 0) {
                    LinkedHashSet rootsForModules = ContainerUtil.newLinkedHashSet();
                    for (Module forModule : forModules) {
                        rootsForModules.addAll(FilePathReferenceProvider.getRoots(forModule, true));
                    }
                    return rootsForModules;
                }
                return FilePathReferenceProvider.getRoots(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement()), true);
            }

            public FileReference createFileReference(TextRange range, int index, String text2) {
                return FilePathReferenceProvider.this.createFileReference(this, range, index, text2);
            }

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return element1 -> FilePathReferenceProvider.this.isPsiElementAccepted((PsiElement)element1);
            }
        }.getAllReferences();
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        return target instanceof PsiFileSystemItem;
    }

    protected boolean isPsiElementAccepted(PsiElement element) {
        return !(element instanceof PsiJavaFile) || !(element instanceof PsiCompiledElement);
    }

    protected FileReference createFileReference(FileReferenceSet referenceSet, TextRange range, int index, String text2) {
        return new FileReference(referenceSet, range, index, text2);
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Object value2;
        String text2 = null;
        if (element instanceof PsiLiteralExpression && (value2 = ((PsiLiteralExpression)element).getValue()) instanceof String) {
            text2 = (String)value2;
        }
        if (text2 == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        return this.getReferencesByElement(element, text2, 1, true);
    }

    @NotNull
    public static Collection<PsiFileSystemItem> getRoots(@Nullable Module thisModule, boolean includingClasses) {
        PsiDirectory directory;
        if (thisModule == null) {
            return Collections.emptyList();
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)thisModule);
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        PsiManager psiManager = PsiManager.getInstance((Project)thisModule.getProject());
        if (includingClasses) {
            VirtualFile[] libraryUrls;
            for (VirtualFile file : libraryUrls = moduleRootManager.orderEntries().getAllLibrariesAndSdkClassesRoots()) {
                directory = psiManager.findDirectory(file);
                if (directory == null) continue;
                result.add(directory);
            }
        }
        VirtualFile[] sourceRoots = moduleRootManager.orderEntries().recursively().withoutSdk().withoutLibraries().sources().usingCache().getRoots();
        for (VirtualFile root : sourceRoots) {
            directory = psiManager.findDirectory(root);
            if (directory == null) continue;
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage != null && aPackage.getName() != null) {
                result.add(PackagePrefixFileSystemItemImpl.create(directory));
                continue;
            }
            result.add(directory);
        }
        return result;
    }
}

