/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PackagePrefixFileSystemItem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PackagePrefixFileSystemItemImpl
extends PsiElementBase
implements PsiFileSystemItem,
PackagePrefixFileSystemItem {
    @NotNull
    private final PsiDirectory myDirectory;
    private final int myIndex;
    private final PsiPackage[] myPackages;

    public static PackagePrefixFileSystemItemImpl create(@NotNull PsiDirectory directory) {
        ArrayList<PsiPackage> packages = new ArrayList<PsiPackage>();
        for (PsiPackage cur = JavaDirectoryService.getInstance().getPackage(directory); cur != null; cur = cur.getParentPackage()) {
            packages.add(0, cur);
        }
        return new PackagePrefixFileSystemItemImpl(directory, 0, packages.toArray(PsiPackage.EMPTY_ARRAY));
    }

    private PackagePrefixFileSystemItemImpl(@NotNull PsiDirectory directory, int index, PsiPackage[] packages) {
        this.myDirectory = directory;
        this.myIndex = index;
        this.myPackages = packages;
    }

    @NotNull
    public String getName() {
        return StringUtil.notNullize((String)this.myPackages[this.myIndex].getName());
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public boolean isDirectory() {
        return true;
    }

    public PsiFileSystemItem getParent() {
        return this.myIndex > 0 ? new PackagePrefixFileSystemItemImpl(this.myDirectory, this.myIndex - 1, this.myPackages) : this.myDirectory.getParent();
    }

    public PsiFile getContainingFile() throws PsiInvalidElementAccessException {
        return null;
    }

    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return 0;
    }

    public int getTextLength() {
        return 0;
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return 0;
    }

    @NonNls
    public String getText() {
        return "";
    }

    @NotNull
    public char[] textToCharArray() {
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    public boolean textMatches(@NotNull @NonNls CharSequence text2) {
        return false;
    }

    public boolean textMatches(@NotNull PsiElement element) {
        return false;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
    }

    public PsiElement copy() {
        return null;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public void delete() throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public void checkDelete() throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    public boolean isValid() {
        return this.myDirectory.isValid();
    }

    public boolean isWritable() {
        VirtualFile file = this.getVirtualFile();
        return file != null && file.isWritable();
    }

    public boolean isPhysical() {
        VirtualFile file = this.getVirtualFile();
        return file != null && !(file.getFileSystem() instanceof NonPhysicalFileSystem);
    }

    @Nullable
    public ASTNode getNode() {
        return null;
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        if (this.myIndex == this.myPackages.length - 1) {
            return this.myDirectory.processChildren(processor);
        }
        return processor.execute((PsiElement)new PackagePrefixFileSystemItemImpl(this.myDirectory, this.myIndex + 1, this.myPackages));
    }

    @NotNull
    public Language getLanguage() {
        return Language.ANY;
    }

    public PsiManager getManager() {
        return this.myDirectory.getManager();
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray;
        if (this.myIndex == this.myPackages.length - 1) {
            psiElementArray = this.myDirectory.getChildren();
        } else {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = new PackagePrefixFileSystemItemImpl(this.myDirectory, this.myIndex + 1, this.myPackages);
        }
        return psiElementArray;
    }

    public boolean canNavigate() {
        return this.getVirtualFile() != null;
    }

    public VirtualFile getVirtualFile() {
        if (this.myIndex == this.myPackages.length - 1) {
            return this.myDirectory.getVirtualFile();
        }
        return null;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return this.myDirectory.getIcon(flags);
    }

    @NotNull
    public PsiDirectory getDirectory() {
        return this.myDirectory;
    }
}

