/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.impl.source.tree.injected.ConcatenationInjectorManager;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaConcatenationToInjectorAdapter
extends ConcatenationInjectorManager.BaseConcatenation2InjectorAdapter
implements MultiHostInjector {
    private static final List<Class<PsiLiteralExpression>> LITERALS = Collections.singletonList(PsiLiteralExpression.class);

    public JavaConcatenationToInjectorAdapter(ConcatenationInjectorManager manager) {
        super(manager);
    }

    public Pair<PsiElement, PsiElement[]> computeAnchorAndOperands(@NotNull PsiElement context) {
        PsiElement anchor;
        PsiExpression[] operands2;
        PsiElement element = context;
        PsiElement parent = context.getParent();
        while (parent instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent).getOperationTokenType() == JavaTokenType.PLUS || parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getOperationTokenType() == JavaTokenType.PLUSEQ || parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != element || parent instanceof PsiTypeCastExpression || parent instanceof PsiParenthesizedExpression) {
            element = parent;
            parent = parent.getParent();
        }
        if (element instanceof PsiPolyadicExpression) {
            operands2 = ((PsiPolyadicExpression)element).getOperands();
            anchor = element;
        } else if (element instanceof PsiAssignmentExpression) {
            PsiExpression rExpression = ((PsiAssignmentExpression)element).getRExpression();
            operands2 = new PsiElement[]{rExpression == null ? element : rExpression};
            anchor = element;
        } else {
            operands2 = new PsiElement[]{context};
            anchor = context;
        }
        return Pair.create((Object)anchor, (Object)operands2);
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        return LITERALS;
    }
}

