/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterListElement
extends CompositeElement
implements Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.ParameterListElement");
    private static final TokenSet PARAMETER_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.PARAMETER, JavaElementType.RECEIVER_PARAMETER});

    public ParameterListElement() {
        super(PARAMETER_LIST);
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        this.ensureParenthesisAroundParameterList();
        if (anchor == null) {
            if (before == null || before.booleanValue()) {
                anchor = this.findChildByRole(25);
                before = Boolean.TRUE;
            } else {
                anchor = this.findChildByRole(24);
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor, before);
        if (first == last && PARAMETER_SET.contains(first.getElementType())) {
            JavaSourceUtil.addSeparatingComma(this, (ASTNode)first, PARAMETER_SET);
        }
        try {
            CodeStyleManager.getInstance((Project)this.getManager().getProject()).reformat(this.getPsi());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return firstAdded;
    }

    private void ensureParenthesisAroundParameterList() {
        if (this.findChildByRole(24) == null) {
            this.addLeaf(JavaTokenType.LPARENTH, "(", (ASTNode)this.getFirstChildNode());
            this.addLeaf(JavaTokenType.RPARENTH, ")", null);
        }
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        TreeElement newFirstNodeInsideParens;
        TreeElement oldLastNodeInsideParens = this.getLastNodeInsideParens();
        TreeElement oldFirstNodeInsideParens = this.getFirstNodeInsideParens();
        if (PARAMETER_SET.contains(child.getElementType())) {
            JavaSourceUtil.deleteSeparatingComma(this, child);
            this.ensureParenthesisAroundParameterList();
        }
        super.deleteChildInternal(child);
        TreeElement newLastNodeInsideParens = this.getLastNodeInsideParens();
        if (newLastNodeInsideParens != null && oldLastNodeInsideParens != null && newLastNodeInsideParens.getElementType() == WHITE_SPACE) {
            if (oldLastNodeInsideParens.getElementType() != WHITE_SPACE) {
                this.deleteChildInternal((ASTNode)newLastNodeInsideParens);
            } else {
                this.replaceChild((ASTNode)newLastNodeInsideParens, (ASTNode)oldLastNodeInsideParens.clone());
            }
        }
        if ((newFirstNodeInsideParens = this.getFirstNodeInsideParens()) != null && newFirstNodeInsideParens.getElementType() == WHITE_SPACE) {
            if (oldFirstNodeInsideParens == null || oldFirstNodeInsideParens.getElementType() != WHITE_SPACE) {
                this.deleteChildInternal((ASTNode)newFirstNodeInsideParens);
            } else {
                this.replaceChild((ASTNode)newFirstNodeInsideParens, (ASTNode)oldFirstNodeInsideParens.clone());
            }
        }
        try {
            CodeStyleManager.getInstance((Project)this.getManager().getProject()).reformat(this.getPsi());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 24: {
                TreeElement firstNode = this.getFirstChildNode();
                return firstNode.getElementType() == LPARENTH ? firstNode : null;
            }
            case 25: 
        }
        TreeElement lastNode = this.getLastChildNode();
        return lastNode.getElementType() == RPARENTH ? lastNode : null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (PARAMETER_SET.contains(i)) {
            return 15;
        }
        if (i == COMMA) {
            return 23;
        }
        if (i == LPARENTH) {
            return this.getChildRole(child, 24);
        }
        if (i == RPARENTH) {
            return this.getChildRole(child, 25);
        }
        return 0;
    }

    @Nullable
    private TreeElement getLastNodeInsideParens() {
        TreeElement lastNode = this.getLastChildNode();
        return lastNode.getElementType() == RPARENTH ? lastNode.getTreePrev() : null;
    }

    @Nullable
    private TreeElement getFirstNodeInsideParens() {
        TreeElement firstNode = this.getFirstChildNode();
        return firstNode.getElementType() == LPARENTH ? firstNode.getTreeNext() : null;
    }
}

