/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class PsiArrayAccessExpressionImpl
extends ExpressionPsiElement
implements PsiArrayAccessExpression,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiArrayAccessExpressionImpl");

    public PsiArrayAccessExpressionImpl() {
        super(ARRAY_ACCESS_EXPRESSION);
    }

    @NotNull
    public PsiExpression getArrayExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(88);
    }

    public PsiExpression getIndexExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(89);
    }

    public PsiType getType() {
        PsiType arrayType = this.getArrayExpression().getType();
        if (!(arrayType instanceof PsiArrayType)) {
            return null;
        }
        PsiType componentType = ((PsiArrayType)arrayType).getComponentType();
        if (PsiUtil.isAccessedForWriting((PsiExpression)this)) {
            return componentType;
        }
        return PsiUtil.captureToplevelWildcards((PsiType)componentType, (PsiElement)this);
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 88: {
                return this.getFirstChildNode();
            }
            case 89: {
                ASTNode lbracket = this.findChildByRole(74);
                if (lbracket == null) {
                    return null;
                }
                for (ASTNode child = lbracket.getTreeNext(); child != null; child = child.getTreeNext()) {
                    if (!EXPRESSION_BIT_SET.contains(child.getElementType())) continue;
                    return child;
                }
                return null;
            }
            case 74: {
                return this.findChildByType(LBRACKET);
            }
            case 75: 
        }
        return this.findChildByType(RBRACKET);
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == LBRACKET) {
            return 74;
        }
        if (i == RBRACKET) {
            return 75;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return child == this.getFirstChildNode() ? 88 : 89;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitArrayAccessExpression((PsiArrayAccessExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiArrayAccessExpression:" + this.getText();
    }
}

