/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class PsiArrayInitializerMemberValueImpl
extends CompositePsiElement
implements PsiArrayInitializerMemberValue {
    private static final Logger LOG = Logger.getInstance(PsiArrayInitializerMemberValueImpl.class);
    private static final TokenSet MEMBER_SET = ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET;

    public PsiArrayInitializerMemberValueImpl() {
        super(JavaElementType.ANNOTATION_ARRAY_INITIALIZER);
    }

    @NotNull
    public PsiAnnotationMemberValue[] getInitializers() {
        return (PsiAnnotationMemberValue[])this.getChildrenAsPsiElements(MEMBER_SET, PsiAnnotationMemberValue.ARRAY_FACTORY);
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 18: {
                return this.findChildByType(JavaTokenType.LBRACE);
            }
            case 19: 
        }
        return this.findChildByType(JavaTokenType.RBRACE);
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.COMMA) {
            return 23;
        }
        if (i == JavaTokenType.LBRACE) {
            return 18;
        }
        if (i == JavaTokenType.RBRACE) {
            return 19;
        }
        if (MEMBER_SET.contains(child.getElementType())) {
            return 249;
        }
        return 0;
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (MEMBER_SET.contains(first.getElementType()) && MEMBER_SET.contains(last.getElementType())) {
            TreeElement firstAdded = super.addInternal(first, last, anchor, before);
            JavaSourceUtil.addSeparatingComma((CompositeElement)this, (ASTNode)first, MEMBER_SET);
            return firstAdded;
        }
        return super.addInternal(first, last, anchor, before);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (MEMBER_SET.contains(child.getElementType())) {
            JavaSourceUtil.deleteSeparatingComma((CompositeElement)this, child);
        }
        super.deleteChildInternal(child);
    }

    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnnotationArrayInitializer((PsiArrayInitializerMemberValue)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiArrayInitializerMemberValue:" + this.getText();
    }
}

