/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;

public class PsiBinaryExpressionImpl
extends ExpressionPsiElement
implements PsiBinaryExpression {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiBinaryExpressionImpl");
    private static final Function<PsiBinaryExpressionImpl, PsiType> MY_TYPE_EVALUATOR = expression2 -> PsiBinaryExpressionImpl.doGetType(expression2);
    private static final TokenSet OUR_OPERATIONS_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.OROR, JavaTokenType.ANDAND, JavaTokenType.OR, JavaTokenType.XOR, JavaTokenType.AND, JavaTokenType.EQEQ, JavaTokenType.NE, JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE, JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT, JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC});

    public PsiBinaryExpressionImpl() {
        this(JavaElementType.BINARY_EXPRESSION);
    }

    protected PsiBinaryExpressionImpl(@NotNull IElementType elementType) {
        super(elementType);
    }

    @NotNull
    public PsiExpression getLOperand() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(61);
    }

    public PsiExpression getROperand() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(62);
    }

    @NotNull
    public PsiJavaToken getOperationSign() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(63);
    }

    @NotNull
    public IElementType getOperationTokenType() {
        return this.getOperationSign().getTokenType();
    }

    public PsiJavaToken getTokenBeforeOperand(@NotNull PsiExpression operand2) {
        if (operand2 != this.getROperand()) {
            return null;
        }
        return this.getOperationSign();
    }

    private static PsiType doGetType(PsiBinaryExpressionImpl param) {
        IElementType sign;
        PsiExpression lOperand = param.getLOperand();
        PsiExpression rOperand = param.getROperand();
        if (rOperand == null) {
            return null;
        }
        PsiType rType = rOperand.getType();
        PsiType type2 = TypeConversionUtil.calcTypeForBinaryExpression(null, (PsiType)rType, (IElementType)(sign = param.getOperationTokenType()), (boolean)false);
        if (type2 != TypeConversionUtil.NULL_TYPE) {
            return type2;
        }
        PsiType lType = lOperand.getType();
        return TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)rType, (IElementType)sign, (boolean)true);
    }

    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, MY_TYPE_EVALUATOR);
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 61: {
                return this.getFirstChildNode();
            }
            case 62: {
                return ElementType.EXPRESSION_BIT_SET.contains(this.getLastChildNode().getElementType()) ? this.getLastChildNode() : null;
            }
            case 63: 
        }
        return this.findChildByType(OUR_OPERATIONS_BIT_SET);
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            if (child == this.getFirstChildNode()) {
                return 61;
            }
            if (child == this.getLastChildNode()) {
                return 62;
            }
            return 0;
        }
        if (OUR_OPERATIONS_BIT_SET.contains(child.getElementType())) {
            return 63;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitBinaryExpression((PsiBinaryExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiBinaryExpression:" + this.getText();
    }

    @NotNull
    public PsiExpression[] getOperands() {
        PsiExpression[] psiExpressionArray;
        PsiExpression rOperand = this.getROperand();
        if (rOperand == null) {
            PsiExpression[] psiExpressionArray2 = new PsiExpression[1];
            psiExpressionArray = psiExpressionArray2;
            psiExpressionArray2[0] = this.getLOperand();
        } else {
            PsiExpression[] psiExpressionArray3 = new PsiExpression[2];
            psiExpressionArray3[0] = this.getLOperand();
            psiExpressionArray = psiExpressionArray3;
            psiExpressionArray3[1] = rOperand;
        }
        return psiExpressionArray;
    }
}

