/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiBreakStatementImpl
extends CompositePsiElement
implements PsiBreakStatement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiBreakStatementImpl");

    public PsiBreakStatementImpl() {
        super(JavaElementType.BREAK_STATEMENT);
    }

    public PsiReferenceExpression getLabelExpression() {
        PsiExpression expression2 = this.getExpression();
        boolean isLabel = PsiImplUtil.isUnqualifiedReference(expression2) && !(PsiImplUtil.findEnclosingSwitchOrLoop((PsiElement)this) instanceof PsiSwitchExpression);
        return isLabel ? (PsiReferenceExpression)expression2 : null;
    }

    public PsiExpression getValueExpression() {
        PsiExpression expression2 = this.getExpression();
        boolean isValue = expression2 != null && PsiImplUtil.findEnclosingSwitchOrLoop((PsiElement)this) instanceof PsiSwitchExpression;
        return isValue ? expression2 : null;
    }

    public PsiExpression getExpression() {
        return (PsiExpression)this.findPsiChildByType(ElementType.EXPRESSION_BIT_SET);
    }

    public PsiElement findExitedElement() {
        PsiElement enclosing = PsiImplUtil.findEnclosingSwitchOrLoop((PsiElement)this);
        PsiExpression expression2 = this.getExpression();
        if (enclosing instanceof PsiSwitchExpression || !PsiImplUtil.isUnqualifiedReference(expression2)) {
            return enclosing;
        }
        PsiLabeledStatement labeled = PsiImplUtil.findEnclosingLabeledStatement((PsiElement)this, expression2.getText());
        if (labeled != null) {
            return labeled.getStatement();
        }
        return null;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 81: {
                return this.findChildByType(JavaTokenType.BREAK_KEYWORD);
            }
            case 83: {
                return this.findChildByType(ElementType.EXPRESSION_BIT_SET);
            }
            case 22: {
                return TreeUtil.findChildBackward((ASTNode)this, (IElementType)JavaTokenType.SEMICOLON);
            }
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.BREAK_KEYWORD) {
            return 81;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(i)) {
            return 83;
        }
        if (i == JavaTokenType.SEMICOLON) {
            return 22;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitBreakStatement((PsiBreakStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiBreakStatement";
    }
}

