/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiClassObjectAccessExpressionImpl
extends ExpressionPsiElement
implements PsiClassObjectAccessExpression,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiClassObjectAccessExpressionImpl");

    public PsiClassObjectAccessExpressionImpl() {
        super(CLASS_OBJECT_ACCESS_EXPRESSION);
    }

    @NotNull
    public PsiType getType() {
        return PsiImplUtil.getType(this);
    }

    @NotNull
    public PsiTypeElement getOperand() {
        return (PsiTypeElement)this.findChildByRoleAsPsiElement(10);
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 10: {
                return this.findChildByType(TYPE);
            }
            case 55: {
                return this.findChildByType(DOT);
            }
            case 90: 
        }
        return this.findChildByType(CLASS_KEYWORD);
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == TYPE) {
            return 10;
        }
        if (i == DOT) {
            return 55;
        }
        if (i == CLASS_KEYWORD) {
            return 90;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitClassObjectAccessExpression((PsiClassObjectAccessExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiClassObjectAccessExpression:" + this.getText();
    }

    protected Icon computeBaseIcon(int flags) {
        return this.getElementIcon(flags);
    }

    @NotNull
    public Icon getElementIcon(int flags) {
        RowIcon rowIcon = ElementBase.createLayeredIcon((Iconable)this, (Icon)PlatformIcons.FIELD_ICON, (int)0);
        rowIcon.setIcon(PlatformIcons.PUBLIC_ICON, 1);
        return rowIcon;
    }
}

