/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.PsiLoopStatementImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiForStatementImpl
extends PsiLoopStatementImpl
implements PsiForStatement,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiForStatementImpl");

    public PsiForStatementImpl() {
        super(FOR_STATEMENT);
    }

    public PsiStatement getInitialization() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(39);
    }

    public PsiExpression getCondition() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(32);
    }

    public PsiStatement getUpdate() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(40);
    }

    public PsiStatement getBody() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(38);
    }

    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
    }

    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    public ASTNode findChildByRole(int role) {
        ASTNode rparenth;
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 37: {
                return this.findChildByType(FOR_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 39: {
                ASTNode paren;
                ASTNode initialization = PsiImplUtil.findStatementChild(this);
                for (ASTNode child = paren = this.findChildByRole(24); child != null; child = child.getTreeNext()) {
                    if (child == initialization) {
                        return initialization;
                    }
                    if (child.getElementType() != RPARENTH) continue;
                    return null;
                }
                return null;
            }
            case 32: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 41: {
                return this.findChildByType(SEMICOLON);
            }
            case 40: {
                ASTNode semicolon;
                for (ASTNode child = semicolon = this.findChildByRole(41); child != null; child = child.getTreeNext()) {
                    if (child.getPsi() instanceof PsiStatement) {
                        return child;
                    }
                    if (child.getElementType() == RPARENTH) break;
                }
                return null;
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 38: 
        }
        for (ASTNode child = rparenth = this.findChildByRole(25); child != null; child = child.getTreeNext()) {
            if (!(child.getPsi() instanceof PsiStatement)) continue;
            return child;
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == FOR_KEYWORD) {
            return 37;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (i == SEMICOLON) {
            return 41;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 32;
        }
        if (child.getPsi() instanceof PsiStatement) {
            int role = this.getChildRole(child, 39);
            if (role != 0) {
                return role;
            }
            role = this.getChildRole(child, 40);
            if (role != 0) {
                return role;
            }
            return 38;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitForStatement((PsiForStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiForStatement";
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (this.getChildRole(child) == 39) {
            this.replaceChildInternal(child, (TreeElement)JavaPsiFacade.getElementFactory((Project)this.getProject()).createStatementFromText(";", null));
        } else {
            super.deleteChildInternal(child);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        if (lastParent == null || lastParent.getParent() != this) {
            return true;
        }
        return PsiScopesUtil.walkChildrenScopes((PsiElement)this, processor, state, lastParent, place);
    }
}

