/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiInstanceOfExpressionImpl
extends ExpressionPsiElement
implements PsiInstanceOfExpression,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiInstanceOfExpressionImpl");

    public PsiInstanceOfExpressionImpl() {
        super(INSTANCE_OF_EXPRESSION);
    }

    @NotNull
    public PsiExpression getOperand() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(67);
    }

    public PsiTypeElement getCheckType() {
        return (PsiTypeElement)this.findChildByRoleAsPsiElement(10);
    }

    public PsiType getType() {
        return PsiType.BOOLEAN;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 67: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 68: {
                return this.findChildByType(INSTANCEOF_KEYWORD);
            }
            case 10: 
        }
        return this.findChildByType(TYPE);
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == TYPE) {
            return 10;
        }
        if (i == INSTANCEOF_KEYWORD) {
            return 68;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 67;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitInstanceOfExpression((PsiInstanceOfExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiInstanceofExpression:" + this.getText();
    }
}

