/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLabeledStatementImpl
extends CompositePsiElement
implements PsiLabeledStatement,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiLabeledStatementImpl");

    public PsiLabeledStatementImpl() {
        super(LABELED_STATEMENT);
    }

    @NotNull
    public PsiIdentifier getLabelIdentifier() {
        return (PsiIdentifier)this.findChildByRoleAsPsiElement(93);
    }

    public PsiStatement getStatement() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(94);
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 94: {
                return PsiImplUtil.findStatementChild(this);
            }
            case 87: {
                return this.findChildByType(COLON);
            }
            case 93: 
        }
        return this.getFirstChildNode();
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == IDENTIFIER) {
            return 93;
        }
        if (i == COLON) {
            return 87;
        }
        if (child.getPsi() instanceof PsiStatement) {
            return 94;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitLabeledStatement((PsiLabeledStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiLabeledStatement";
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (lastParent != null && lastParent.getParent() != this) {
            PsiElement[] children;
            for (PsiElement aChildren : children = this.getChildren()) {
                if (aChildren.processDeclarations(processor, state, null, place)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String getName() {
        return this.getLabelIdentifier().getText();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        PsiImplUtil.setName((PsiElement)this.getLabelIdentifier(), name);
        return this;
    }

    @NotNull
    public SearchScope getUseScope() {
        return new LocalSearchScope((PsiElement)this);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getLabelIdentifier();
    }
}

