/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiParenthesizedExpressionImpl
extends ExpressionPsiElement
implements PsiParenthesizedExpression,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiParenthesizedExpressionImpl");

    public PsiParenthesizedExpressionImpl() {
        super(PARENTH_EXPRESSION);
    }

    @Nullable
    public PsiExpression getExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(64);
    }

    public PsiType getType() {
        PsiExpression expr = this.getExpression();
        if (expr == null) {
            return null;
        }
        return expr.getType();
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 64: 
        }
        return this.findChildByType(EXPRESSION_BIT_SET);
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 64;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitParenthesizedExpression((PsiParenthesizedExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiParenthesizedExpression:" + this.getText();
    }
}

