/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.PsiLocalVariableImpl;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiResourceVariableImpl
extends PsiLocalVariableImpl
implements PsiResourceVariable {
    public PsiResourceVariableImpl() {
        super(JavaElementType.RESOURCE_VARIABLE);
    }

    @NotNull
    public PsiElement[] getDeclarationScope() {
        PsiElement[] psiElementArray;
        PsiResourceList resourceList = (PsiResourceList)this.getParent();
        PsiTryStatement tryStatement = (PsiTryStatement)resourceList.getParent();
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock != null) {
            PsiElement[] psiElementArray2 = new PsiElement[2];
            psiElementArray2[0] = resourceList;
            psiElementArray = psiElementArray2;
            psiElementArray2[1] = tryBlock;
        } else {
            PsiElement[] psiElementArray3 = new PsiElement[1];
            psiElementArray = psiElementArray3;
            psiElementArray3[0] = resourceList;
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiTypeElement getTypeElement() {
        return (PsiTypeElement)PsiTreeUtil.getRequiredChildOfType((PsiElement)this, PsiTypeElement.class);
    }

    @Override
    public PsiModifierList getModifierList() {
        return (PsiModifierList)PsiTreeUtil.getChildOfType((PsiElement)this, PsiModifierList.class);
    }

    public void delete() throws IncorrectOperationException {
        PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)this);
        if (PsiUtil.isJavaToken((PsiElement)next, (IElementType)JavaTokenType.SEMICOLON)) {
            this.getParent().deleteChildRange((PsiElement)this, next);
            return;
        }
        PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)this);
        if (PsiUtil.isJavaToken((PsiElement)prev, (IElementType)JavaTokenType.SEMICOLON)) {
            this.getParent().deleteChildRange(prev, (PsiElement)this);
            return;
        }
        super.delete();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitResourceVariable((PsiResourceVariable)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        return new LocalSearchScope(this.getDeclarationScope());
    }

    @Override
    public String toString() {
        return "PsiResourceVariable:" + this.getName();
    }
}

