/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.PsiSwitchBlockImpl;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiSwitchExpressionImpl
extends PsiSwitchBlockImpl
implements PsiSwitchExpression {
    public PsiSwitchExpressionImpl() {
        super(JavaElementType.SWITCH_EXPRESSION);
    }

    @Override
    public PsiExpression getExpression() {
        return (PsiExpression)this.findPsiChildByType(ElementType.EXPRESSION_BIT_SET);
    }

    public PsiType getType() {
        if (PsiPolyExpressionUtil.isPolyExpression((PsiExpression)this) && !MethodCandidateInfo.ourOverloadGuard.currentStack().contains(PsiUtil.skipParenthesizedExprUp((PsiElement)this.getParent()))) {
            return InferenceSession.getTargetType((PsiElement)this);
        }
        List resultExpressions = PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)this);
        HashSet<PsiType> resultTypes = new HashSet<PsiType>();
        for (PsiExpression expression2 : resultExpressions) {
            PsiType resultExpressionType = expression2.getType();
            if (resultExpressionType == null) {
                return null;
            }
            resultTypes.add(resultExpressionType);
        }
        if (resultTypes.isEmpty()) {
            return null;
        }
        if (resultTypes.size() == 1) {
            return (PsiType)ContainerUtil.getFirstItem(resultTypes);
        }
        if (resultTypes.stream().allMatch(type2 -> PsiType.BOOLEAN.isAssignableFrom(type2))) {
            return PsiType.BOOLEAN;
        }
        int[] ranks = resultTypes.stream().mapToInt(type2 -> TypeConversionUtil.getTypeRank((PsiType)type2)).toArray();
        int maxRank = ArrayUtil.max((int[])ranks);
        if (TypeConversionUtil.isNumericType((int)maxRank)) {
            if (maxRank == 7) {
                return PsiType.DOUBLE;
            }
            if (maxRank == 6) {
                return PsiType.FLOAT;
            }
            if (maxRank == 5) {
                return PsiType.LONG;
            }
            if (PsiSwitchExpressionImpl.isNumericPromotion(resultExpressions, ranks, PsiType.CHAR)) {
                return PsiType.CHAR;
            }
            if (PsiSwitchExpressionImpl.isNumericPromotion(resultExpressions, ranks, PsiType.SHORT)) {
                return PsiType.SHORT;
            }
            if (PsiSwitchExpressionImpl.isNumericPromotion(resultExpressions, ranks, PsiType.BYTE)) {
                return PsiType.BYTE;
            }
            return PsiType.INT;
        }
        PsiPrimitiveType leastUpperBound = PsiType.NULL;
        for (PsiType type3 : resultTypes) {
            if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type3)) {
                type3 = ((PsiPrimitiveType)type3).getBoxedType((PsiElement)this);
            }
            if (leastUpperBound == PsiType.NULL) {
                leastUpperBound = type3;
                continue;
            }
            leastUpperBound = GenericsUtil.getLeastUpperBound((PsiType)type3, (PsiType)leastUpperBound, (PsiManager)this.getManager());
        }
        return leastUpperBound != null ? PsiUtil.captureToplevelWildcards((PsiType)leastUpperBound, (PsiElement)this) : null;
    }

    private static boolean isNumericPromotion(List<PsiExpression> resultExpressions, int[] ranks, PsiPrimitiveType type2) {
        return ArrayUtil.find((int[])ranks, (int)TypeConversionUtil.getTypeRank((PsiType)type2)) > -1 && resultExpressions.stream().allMatch(expression2 -> TypeConversionUtil.areTypesAssignmentCompatible((PsiType)type2, (PsiExpression)expression2));
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitSwitchExpression((PsiSwitchExpression)this);
        } else {
            super.accept(visitor);
        }
    }

    public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
        super.replaceChildInternal(child, JavaSourceUtil.addParenthToReplacedChild(child, newElement, (PsiManager)this.getManager()));
    }

    public String toString() {
        PsiExpression expression2 = this.getExpression();
        return "PsiSwitchExpression: " + (expression2 != null ? expression2.getText() : "(incomplete)");
    }
}

