/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.PsiSwitchBlockImpl;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiSwitchStatementImpl
extends PsiSwitchBlockImpl
implements PsiSwitchStatement {
    private static final Logger LOG = Logger.getInstance(PsiSwitchBlockImpl.class);

    public PsiSwitchStatementImpl() {
        super(JavaElementType.SWITCH_STATEMENT);
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 42: {
                return this.findChildByType(JavaTokenType.SWITCH_KEYWORD);
            }
            case 24: {
                return this.findChildByType(JavaTokenType.LPARENTH);
            }
            case 43: {
                return this.findChildByType(ElementType.EXPRESSION_BIT_SET);
            }
            case 25: {
                return this.findChildByType(JavaTokenType.RPARENTH);
            }
            case 44: {
                return this.findChildByType((IElementType)JavaElementType.CODE_BLOCK);
            }
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.SWITCH_KEYWORD) {
            return 42;
        }
        if (i == JavaTokenType.LPARENTH) {
            return 24;
        }
        if (i == JavaTokenType.RPARENTH) {
            return 25;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 43;
        }
        if (child.getElementType() == JavaElementType.CODE_BLOCK) {
            return 44;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitSwitchStatement((PsiSwitchStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiSwitchStatement";
    }
}

