/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.conflictResolvers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMethodsConflictResolver
implements PsiConflictResolver {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver");
    private final PsiElement myArgumentsList;
    private final PsiType[] myActualParameterTypes;
    protected LanguageLevel myLanguageLevel;

    public JavaMethodsConflictResolver(@NotNull PsiExpressionList list, @NotNull LanguageLevel languageLevel) {
        this((PsiElement)list, null, languageLevel);
    }

    public JavaMethodsConflictResolver(@NotNull PsiElement argumentsList, PsiType[] actualParameterTypes, @NotNull LanguageLevel languageLevel) {
        this.myArgumentsList = argumentsList;
        this.myActualParameterTypes = actualParameterTypes;
        this.myLanguageLevel = languageLevel;
    }

    @Override
    public final CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
        MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod((PsiElement)this.myArgumentsList);
        if (properties != null && properties.isApplicabilityCheck()) {
            PsiMethod method = properties.getMethod();
            LOG.error("Recursive conflict resolution for:" + method + "; " + this.myArgumentsList.getText() + "; file=" + (method == null ? "<unknown>" : method.getContainingFile()));
        }
        return (CandidateInfo)MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion((Object)this.myArgumentsList, false, () -> this.guardedOverloadResolution(conflicts));
    }

    @Nullable
    protected CandidateInfo guardedOverloadResolution(@NotNull List<CandidateInfo> conflicts) {
        if (conflicts.isEmpty()) {
            return null;
        }
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        Map map2 = FactoryMap.create(key2 -> key2.getSubstitutor(false));
        boolean atLeastOneMatch = this.checkParametersNumber(conflicts, this.getActualParametersLength(), map2, true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkSameSignatures(conflicts, map2);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        JavaMethodsConflictResolver.checkAccessStaticLevels(conflicts, true);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkParametersNumber(conflicts, this.getActualParametersLength(), map2, false);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkStaticMethodsOfInterfaces(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        if (atLeastOneMatch) {
            JavaMethodsConflictResolver.checkPotentiallyCompatibleMethods(conflicts);
            if (conflicts.size() == 1) {
                return conflicts.get(0);
            }
        }
        int applicabilityLevel = this.checkApplicability(conflicts);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        if (!atLeastOneMatch) {
            return null;
        }
        this.checkSpecifics(conflicts, applicabilityLevel, map2, 0);
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        this.checkPrimitiveVarargs(conflicts, this.getActualParametersLength());
        if (conflicts.size() == 1) {
            return conflicts.get(0);
        }
        THashSet uniques = new THashSet(conflicts);
        if (uniques.size() == 1) {
            return (CandidateInfo)uniques.iterator().next();
        }
        return null;
    }

    private static void checkPotentiallyCompatibleMethods(@NotNull List<CandidateInfo> conflicts) {
        ArrayList<CandidateInfo> partiallyApplicable = new ArrayList<CandidateInfo>();
        Iterator<CandidateInfo> iterator = conflicts.iterator();
        while (iterator.hasNext()) {
            CandidateInfo conflict = iterator.next();
            if (!(conflict instanceof MethodCandidateInfo)) continue;
            ThreeState compatible = ((MethodCandidateInfo)conflict).isPotentiallyCompatible();
            if (compatible == ThreeState.NO) {
                iterator.remove();
                continue;
            }
            if (compatible != ThreeState.UNSURE) continue;
            partiallyApplicable.add(conflict);
        }
        if (conflicts.size() > partiallyApplicable.size()) {
            conflicts.removeAll(partiallyApplicable);
        }
    }

    public void checkSpecifics(@NotNull List<CandidateInfo> conflicts, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel) {
        this.checkSpecifics(conflicts, applicabilityLevel, null, 0);
    }

    public void checkSpecifics(@NotNull List<CandidateInfo> conflicts, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, Map<MethodCandidateInfo, PsiSubstitutor> map2, int offset) {
        boolean applicable = applicabilityLevel > 1;
        int conflictsCount = conflicts.size();
        if (applicable) {
            CandidateInfo[] newConflictsArray = conflicts.toArray(CandidateInfo.EMPTY_ARRAY);
            for (int i = 1; i < conflictsCount; ++i) {
                CandidateInfo method = newConflictsArray[i];
                block5: for (int j = 0; j < i; ++j) {
                    ProgressManager.checkCanceled();
                    CandidateInfo conflict = newConflictsArray[j];
                    if (this.nonComparable(method, conflict, applicabilityLevel == 3)) continue;
                    switch (this.isMoreSpecific((MethodCandidateInfo)method, (MethodCandidateInfo)conflict, applicabilityLevel, map2, offset)) {
                        case FIRST: {
                            conflicts.remove(conflict);
                            continue block5;
                        }
                        case SECOND: {
                            conflicts.remove(method);
                            continue block5;
                        }
                    }
                }
            }
        }
    }

    protected boolean nonComparable(@NotNull CandidateInfo method, @NotNull CandidateInfo conflict, boolean fixedArity) {
        assert (method != conflict);
        return false;
    }

    protected static void checkAccessStaticLevels(@NotNull List<? extends CandidateInfo> conflicts, boolean checkAccessible) {
        int conflictsCount = conflicts.size();
        int maxCheckLevel = -1;
        int[] checkLevels = new int[conflictsCount];
        int index = 0;
        for (CandidateInfo candidateInfo : conflicts) {
            ProgressManager.checkCanceled();
            MethodCandidateInfo method = (MethodCandidateInfo)candidateInfo;
            int level = checkAccessible ? JavaMethodsConflictResolver.getCheckAccessLevel(method) : JavaMethodsConflictResolver.getCheckStaticLevel(method);
            checkLevels[index++] = level;
            maxCheckLevel = Math.max(maxCheckLevel, level);
        }
        for (int i = conflictsCount - 1; i >= 0; --i) {
            if (checkLevels[i] >= maxCheckLevel) continue;
            conflicts.remove(i);
        }
    }

    protected void checkSameSignatures(@NotNull List<? extends CandidateInfo> conflicts) {
        this.checkSameSignatures(conflicts, null);
    }

    protected void checkSameSignatures(@NotNull List<? extends CandidateInfo> conflicts, Map<MethodCandidateInfo, PsiSubstitutor> map2) {
        PsiMethod method;
        THashMap signatures = new THashMap(conflicts.size());
        HashSet<PsiMethod> superMethods = new HashSet<PsiMethod>();
        GlobalSearchScope resolveScope = this.myArgumentsList.getResolveScope();
        for (CandidateInfo candidateInfo : conflicts) {
            method = ((MethodCandidateInfo)candidateInfo).getElement();
            PsiClass containingClass = method.getContainingClass();
            boolean isInterface = containingClass != null && containingClass.isInterface();
            for (HierarchicalMethodSignature methodSignature : PsiSuperMethodImplUtil.getHierarchicalMethodSignature(method, resolveScope).getSuperSignatures()) {
                PsiMethod superMethod = methodSignature.getMethod();
                if (!isInterface) {
                    superMethods.add(superMethod);
                    continue;
                }
                PsiClass aClass = superMethod.getContainingClass();
                if (aClass == null || "java.lang.Object".equals(aClass.getQualifiedName())) continue;
                superMethods.add(superMethod);
            }
        }
        for (int i = 0; i < conflicts.size(); ++i) {
            ProgressManager.checkCanceled();
            CandidateInfo candidateInfo = conflicts.get(i);
            method = (PsiMethod)candidateInfo.getElement();
            if (!method.hasModifierProperty("static") && superMethods.contains(method)) {
                conflicts.remove(i);
                --i;
                continue;
            }
            PsiClass class1 = method.getContainingClass();
            PsiSubstitutor infoSubstitutor = JavaMethodsConflictResolver.getSubstitutor((MethodCandidateInfo)candidateInfo, map2);
            MethodSignature signature = method.getSignature(infoSubstitutor);
            CandidateInfo existing = (CandidateInfo)signatures.get(signature);
            if (existing == null) {
                signatures.put(signature, candidateInfo);
                continue;
            }
            PsiMethod existingMethod = (PsiMethod)existing.getElement();
            PsiClass existingClass = existingMethod.getContainingClass();
            if (class1 != null && existingClass != null) {
                if (class1.isInterface() && "java.lang.Object".equals(existingClass.getQualifiedName())) {
                    signatures.put(signature, candidateInfo);
                    continue;
                }
                if (existingClass.isInterface() && "java.lang.Object".equals(class1.getQualifiedName())) {
                    conflicts.remove(candidateInfo);
                    --i;
                    continue;
                }
            }
            if (method != existingMethod) continue;
            PsiElement scope1 = candidateInfo.getCurrentFileResolveScope();
            PsiElement scope2 = existing.getCurrentFileResolveScope();
            if (!(scope1 instanceof PsiClass) || !(scope2 instanceof PsiClass) || !PsiTreeUtil.isAncestor((PsiElement)scope1, (PsiElement)scope2, (boolean)true) || existing.isAccessible()) continue;
            signatures.put(signature, candidateInfo);
        }
    }

    @NotNull
    private static PsiSubstitutor getSubstitutor(MethodCandidateInfo existing, Map<MethodCandidateInfo, PsiSubstitutor> map2) {
        return map2 != null ? map2.get(existing) : existing.getSubstitutor(false);
    }

    private static boolean areTypeParametersAgree(@NotNull CandidateInfo info) {
        return ((MethodCandidateInfo)info).getPertinentApplicabilityLevel() != 1;
    }

    private void checkStaticMethodsOfInterfaces(@NotNull List<CandidateInfo> conflicts) {
        if (!(this.myArgumentsList instanceof PsiExpressionList)) {
            return;
        }
        PsiClass qualifierClass = null;
        Iterator<CandidateInfo> iterator = conflicts.iterator();
        while (iterator.hasNext()) {
            PsiClass containingClass;
            PsiMethod method;
            CandidateInfo conflict = iterator.next();
            if (!(conflict instanceof MethodCandidateInfo) || !(method = ((MethodCandidateInfo)conflict).getElement()).hasModifierProperty("static") || conflict.getCurrentFileResolveScope() instanceof PsiImportStaticStatement || (containingClass = method.getContainingClass()) == null || !containingClass.isInterface()) continue;
            if (qualifierClass == null && (qualifierClass = this.getQualifiedClass(method)) == null) {
                return;
            }
            if (containingClass.getManager().areElementsEquivalent((PsiElement)containingClass, (PsiElement)qualifierClass)) continue;
            iterator.remove();
        }
    }

    private PsiClass getQualifiedClass(PsiMethod method) {
        PsiElement parent = this.myArgumentsList.getParent();
        if (parent instanceof PsiMethodCallExpression) {
            PsiClass qualifierClass;
            PsiExpression expression2 = ((PsiMethodCallExpression)parent).getMethodExpression().getQualifierExpression();
            if (expression2 instanceof PsiReferenceExpression) {
                PsiElement resolve = ((PsiReferenceExpression)expression2).resolve();
                if (resolve instanceof PsiClass) {
                    return (PsiClass)resolve;
                }
            } else if (expression2 == null && !ImportsUtil.hasStaticImportOn((PsiElement)parent, (PsiMember)method, (boolean)true) && (qualifierClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class)) != null && !PsiTreeUtil.isAncestor((PsiElement)method.getContainingClass(), (PsiElement)qualifierClass, (boolean)false)) {
                return qualifierClass;
            }
            if (expression2 != null) {
                return PsiUtil.resolveClassInType((PsiType)expression2.getType());
            }
        }
        return null;
    }

    public boolean checkParametersNumber(@NotNull List<? extends CandidateInfo> conflicts, int argumentsCount, Map<MethodCandidateInfo, PsiSubstitutor> map2, boolean ignoreIfStaticsProblem) {
        boolean atLeastOneMatch = false;
        TIntArrayList unmatchedIndices = null;
        for (int i = 0; i < conflicts.size(); ++i) {
            boolean isVarargs;
            ProgressManager.checkCanceled();
            CandidateInfo info = conflicts.get(i);
            if (ignoreIfStaticsProblem && !info.isStaticsScopeCorrect()) {
                return true;
            }
            if (!(info instanceof MethodCandidateInfo)) continue;
            PsiMethod method = ((MethodCandidateInfo)info).getElement();
            int parametersCount = method.getParameterList().getParametersCount();
            boolean bl = (this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? ((MethodCandidateInfo)info).isVarargs() : method.isVarArgs()) && parametersCount - 1 <= argumentsCount ? true : (isVarargs = false);
            if (isVarargs || parametersCount == argumentsCount) {
                if (unmatchedIndices != null) {
                    for (int u = unmatchedIndices.size() - 1; u >= 0; --u) {
                        MethodCandidateInfo candidateInfo;
                        PsiMethod candidateToRemove;
                        int index = unmatchedIndices.get(u);
                        if (ignoreIfStaticsProblem && isVarargs && (candidateToRemove = (candidateInfo = (MethodCandidateInfo)conflicts.get(index)).getElement()) != method) {
                            PsiSubstitutor candidateToRemoveSubst = map2.get(candidateInfo);
                            PsiSubstitutor substitutor = map2.get(info);
                            if (MethodSignatureUtil.isSubsignature((MethodSignature)candidateToRemove.getSignature(candidateToRemoveSubst), (MethodSignature)method.getSignature(substitutor))) continue;
                        }
                        conflicts.remove(index);
                        --i;
                    }
                    unmatchedIndices = null;
                }
                atLeastOneMatch = true;
                continue;
            }
            if (atLeastOneMatch) {
                conflicts.remove(i);
                --i;
                continue;
            }
            if (unmatchedIndices == null) {
                unmatchedIndices = new TIntArrayList(conflicts.size() - i);
            }
            unmatchedIndices.add(i);
        }
        return atLeastOneMatch;
    }

    @MethodCandidateInfo.ApplicabilityLevelConstant
    public int checkApplicability(@NotNull List<CandidateInfo> conflicts) {
        int level;
        int maxApplicabilityLevel = 0;
        boolean toFilter = false;
        for (CandidateInfo conflict : conflicts) {
            ProgressManager.checkCanceled();
            level = this.getPertinentApplicabilityLevel((MethodCandidateInfo)conflict);
            if (maxApplicabilityLevel > 0 && maxApplicabilityLevel != level) {
                toFilter = true;
            }
            if (level <= maxApplicabilityLevel) continue;
            maxApplicabilityLevel = level;
        }
        if (toFilter) {
            Iterator<CandidateInfo> iterator = conflicts.iterator();
            while (iterator.hasNext()) {
                ProgressManager.checkCanceled();
                CandidateInfo info = iterator.next();
                level = this.getPertinentApplicabilityLevel((MethodCandidateInfo)info);
                if (level >= maxApplicabilityLevel) continue;
                iterator.remove();
            }
        }
        return maxApplicabilityLevel;
    }

    protected int getPertinentApplicabilityLevel(@NotNull MethodCandidateInfo conflict) {
        return conflict.getPertinentApplicabilityLevel();
    }

    private static int getCheckAccessLevel(@NotNull MethodCandidateInfo method) {
        boolean visible = method.isAccessible();
        return visible ? 1 : 0;
    }

    private static int getCheckStaticLevel(@NotNull MethodCandidateInfo method) {
        boolean available = method.isStaticsScopeCorrect();
        return (available ? 1 : 0) << 1 | (method.getCurrentFileResolveScope() instanceof PsiImportStaticStatement ? 0 : 1);
    }

    private int getActualParametersLength() {
        if (this.myActualParameterTypes == null) {
            LOG.assertTrue(this.myArgumentsList instanceof PsiExpressionList, (Object)this.myArgumentsList);
            return ((PsiExpressionList)this.myArgumentsList).getExpressionCount();
        }
        return this.myActualParameterTypes.length;
    }

    private Specifics isMoreSpecific(@NotNull MethodCandidateInfo info1, @NotNull MethodCandidateInfo info2, @MethodCandidateInfo.ApplicabilityLevelConstant int applicabilityLevel, Map<MethodCandidateInfo, PsiSubstitutor> map2, int offset) {
        boolean varargs2;
        boolean varargs1;
        PsiMethod method1 = info1.getElement();
        PsiMethod method2 = info2.getElement();
        PsiClass class1 = method1.getContainingClass();
        PsiClass class2 = method2.getContainingClass();
        PsiParameter[] params1 = method1.getParameterList().getParameters();
        PsiParameter[] params2 = method2.getParameterList().getParameters();
        PsiTypeParameter[] typeParameters1 = method1.getTypeParameters();
        PsiTypeParameter[] typeParameters2 = method2.getTypeParameters();
        PsiSubstitutor classSubstitutor1 = JavaMethodsConflictResolver.getSubstitutor(info1, map2);
        PsiSubstitutor classSubstitutor2 = JavaMethodsConflictResolver.getSubstitutor(info2, map2);
        int argsLength = this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (method1.isVarArgs() || method2.isVarArgs()) ? this.getActualParametersLength() : 0;
        int max = Math.max(Math.max(params1.length, params2.length), argsLength);
        PsiType[] types1 = PsiType.createArray((int)max);
        PsiType[] types2 = PsiType.createArray((int)max);
        boolean[] varargs = new boolean[max];
        boolean varargsPosition = applicabilityLevel == 2;
        for (int i = 0; i < max; ++i) {
            PsiType type2;
            ProgressManager.checkCanceled();
            PsiType type1 = params1.length > 0 ? params1[Math.min(i, params1.length - 1)].getType() : null;
            PsiType psiType = type2 = params2.length > 0 ? params2[Math.min(i, params2.length - 1)].getType() : null;
            if (varargsPosition) {
                if (type1 instanceof PsiEllipsisType && type2 instanceof PsiEllipsisType && params1.length == params2.length && (class1 != null && !JavaVersionService.getInstance().isAtLeast((PsiElement)class1, JavaSdkVersion.JDK_1_7) || ((PsiArrayType)type1).getComponentType().equalsToText("java.lang.Object") || ((PsiArrayType)type2).getComponentType().equalsToText("java.lang.Object"))) {
                    type1 = ((PsiEllipsisType)type1).toArrayType();
                    type2 = ((PsiEllipsisType)type2).toArrayType();
                } else {
                    type1 = type1 instanceof PsiEllipsisType ? ((PsiArrayType)type1).getComponentType() : type1;
                    type2 = type2 instanceof PsiEllipsisType ? ((PsiArrayType)type2).getComponentType() : type2;
                    varargs[i] = true;
                }
            }
            types1[i] = type1;
            types2[i] = type2;
        }
        boolean sameBoxing = true;
        boolean[] boxingHappened = new boolean[2];
        PsiExpression[] args = this.myArgumentsList instanceof PsiExpressionList ? ((PsiExpressionList)this.myArgumentsList).getExpressions() : null;
        for (int i = 0; i < types1.length; ++i) {
            PsiType argType;
            ProgressManager.checkCanceled();
            if (varargs[i]) continue;
            PsiExpression arg = args != null && i < args.length ? args[i] : null;
            PsiType psiType = argType = this.myActualParameterTypes != null && i + offset < this.getActualParametersLength() ? this.myActualParameterTypes[i + offset] : null;
            if (arg == null && argType == null) continue;
            boolean boxingInFirst = false;
            if (JavaMethodsConflictResolver.isBoxingUsed(classSubstitutor1.substitute(types1[i]), argType, arg)) {
                boxingHappened[0] = boxingHappened[0] | true;
                boxingInFirst = true;
            }
            boolean boxingInSecond = false;
            if (JavaMethodsConflictResolver.isBoxingUsed(classSubstitutor2.substitute(types2[i]), argType, arg)) {
                boxingHappened[1] = boxingHappened[1] | true;
                boxingInSecond = true;
            }
            sameBoxing &= boxingInFirst == boxingInSecond;
        }
        if (!boxingHappened[0] && boxingHappened[1]) {
            return Specifics.FIRST;
        }
        if (boxingHappened[0] && !boxingHappened[1]) {
            return Specifics.SECOND;
        }
        if (sameBoxing) {
            PsiSubstitutor siteSubstitutor1 = this.getSiteSubstitutor(info1);
            PsiSubstitutor siteSubstitutor2 = this.getSiteSubstitutor(info2);
            PsiType[] types2AtSite = JavaMethodsConflictResolver.typesAtSite(types2, siteSubstitutor2);
            PsiType[] types1AtSite = JavaMethodsConflictResolver.typesAtSite(types1, siteSubstitutor1);
            PsiSubstitutor methodSubstitutor1 = JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters1, method1, siteSubstitutor1, types1, types2AtSite, this.myLanguageLevel);
            boolean applicable12 = this.isApplicableTo(types2AtSite, method1, this.myLanguageLevel, varargsPosition, methodSubstitutor1, method2, siteSubstitutor2);
            PsiSubstitutor methodSubstitutor2 = JavaMethodsConflictResolver.calculateMethodSubstitutor(typeParameters2, method2, siteSubstitutor2, types2, types1AtSite, this.myLanguageLevel);
            boolean applicable21 = this.isApplicableTo(types1AtSite, method2, this.myLanguageLevel, varargsPosition, methodSubstitutor2, method1, siteSubstitutor1);
            if (!this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                boolean typeArgsApplicable12 = GenericsUtil.isTypeArgumentsApplicable((PsiTypeParameter[])typeParameters1, (PsiSubstitutor)methodSubstitutor1, (PsiElement)this.myArgumentsList, (!applicable21 ? 1 : 0) != 0);
                boolean typeArgsApplicable21 = GenericsUtil.isTypeArgumentsApplicable((PsiTypeParameter[])typeParameters2, (PsiSubstitutor)methodSubstitutor2, (PsiElement)this.myArgumentsList, (!applicable12 ? 1 : 0) != 0);
                if (!typeArgsApplicable12) {
                    applicable12 = false;
                }
                if (!typeArgsApplicable21) {
                    applicable21 = false;
                }
            }
            if (applicable12 || applicable21) {
                boolean abstract2;
                if (applicable12 && !applicable21) {
                    return Specifics.SECOND;
                }
                if (applicable21 && !applicable12) {
                    return Specifics.FIRST;
                }
                boolean abstract1 = method1.hasModifierProperty("abstract") || method1.hasModifierProperty("default");
                boolean bl = abstract2 = method2.hasModifierProperty("abstract") || method2.hasModifierProperty("default");
                if (abstract1 && !abstract2) {
                    return Specifics.SECOND;
                }
                if (abstract2 && !abstract1) {
                    return Specifics.FIRST;
                }
                if (abstract1 && MethodSignatureUtil.areOverrideEquivalent((PsiMethod)method1, (PsiMethod)method2)) {
                    PsiType returnType1 = siteSubstitutor1.substitute(method1.getReturnType());
                    PsiType returnType2 = siteSubstitutor2.substitute(method2.getReturnType());
                    if (returnType1 != null && returnType2 != null && returnType1.isAssignableFrom(returnType2)) {
                        return Specifics.SECOND;
                    }
                    return Specifics.FIRST;
                }
            }
        } else if (varargsPosition) {
            PsiType lastParamType1 = classSubstitutor1.substitute(types1[types1.length - 1]);
            PsiType lastParamType2 = classSubstitutor2.substitute(types2[types1.length - 1]);
            boolean assignable1 = TypeConversionUtil.isAssignable((PsiType)lastParamType2, (PsiType)lastParamType1);
            boolean assignable2 = TypeConversionUtil.isAssignable((PsiType)lastParamType1, (PsiType)lastParamType2);
            if (assignable1 && !assignable2) {
                return Specifics.FIRST;
            }
            if (assignable2 && !assignable1) {
                return Specifics.SECOND;
            }
        }
        if (class1 != class2 && (method1.hasModifierProperty("static") || method2.hasModifierProperty("static"))) {
            if (class2.isInheritor(class1, true)) {
                if (MethodSignatureUtil.isSubsignature((MethodSignature)method1.getSignature(classSubstitutor1), (MethodSignature)method2.getSignature(classSubstitutor2))) {
                    return Specifics.SECOND;
                }
            } else if (class1.isInheritor(class2, true) && MethodSignatureUtil.isSubsignature((MethodSignature)method2.getSignature(classSubstitutor2), (MethodSignature)method1.getSignature(classSubstitutor1))) {
                return Specifics.FIRST;
            }
        }
        if ((varargs1 = info1.isVarargs()) ^ (varargs2 = info2.isVarargs())) {
            return varargs1 ? Specifics.SECOND : Specifics.FIRST;
        }
        return Specifics.NEITHER;
    }

    private PsiSubstitutor getSiteSubstitutor(@NotNull MethodCandidateInfo info) {
        PsiSubstitutor siteSubstitutor = info.getSiteSubstitutor();
        if (!this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return siteSubstitutor;
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiClass containingClass = info.getElement().getContainingClass();
        if (containingClass != null) {
            for (PsiTypeParameter param : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)containingClass)) {
                substitutor = substitutor.put(param, siteSubstitutor.substitute(param));
            }
        }
        return substitutor;
    }

    private static boolean isBoxingUsed(PsiType parameterType, @Nullable PsiType argType, PsiExpression arg) {
        ProgressManager.checkCanceled();
        boolean isExpressionTypePrimitive = argType != null ? argType instanceof PsiPrimitiveType : PsiPolyExpressionUtil.isExpressionOfPrimitiveType((PsiExpression)arg);
        return parameterType instanceof PsiPrimitiveType ^ isExpressionTypePrimitive;
    }

    private boolean isApplicableTo(@NotNull PsiType[] types2AtSite, @NotNull PsiMethod method1, @NotNull LanguageLevel languageLevel, boolean varargsPosition, @NotNull PsiSubstitutor methodSubstitutor1, @NotNull PsiMethod method2, PsiSubstitutor siteSubstitutor1) {
        PsiElement parent;
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && method1.getTypeParameters().length > 0 && this.myArgumentsList instanceof PsiExpressionList && (parent = this.myArgumentsList.getParent()) instanceof PsiCallExpression) {
            return InferenceSession.isMoreSpecific(method2, method1, siteSubstitutor1, ((PsiExpressionList)this.myArgumentsList).getExpressions(), this.myArgumentsList, varargsPosition);
        }
        PsiUtil.ApplicabilityChecker applicabilityChecker = (left, right, allowUncheckedConversion, argId) -> {
            PsiClass rightClass;
            if (right instanceof PsiClassType && (rightClass = ((PsiClassType)right).resolve()) instanceof PsiTypeParameter) {
                right = new PsiImmediateClassType(rightClass, siteSubstitutor1);
            }
            return languageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? this.isTypeMoreSpecific(left, right, argId) : TypeConversionUtil.isAssignable((PsiType)left, (PsiType)right, (boolean)allowUncheckedConversion);
        };
        int applicabilityLevel = PsiUtil.getApplicabilityLevel((PsiMethod)method1, (PsiSubstitutor)methodSubstitutor1, (PsiType[])types2AtSite, (LanguageLevel)languageLevel, (boolean)false, (boolean)varargsPosition, (PsiUtil.ApplicabilityChecker)applicabilityChecker);
        return applicabilityLevel > 1;
    }

    private boolean isTypeMoreSpecific(PsiType left, PsiType right, int argId) {
        PsiExpression[] expressions2;
        if (TypeConversionUtil.isAssignable((PsiType)left, (PsiType)right, (boolean)false)) {
            return true;
        }
        if (this.myArgumentsList instanceof PsiExpressionList && argId < (expressions2 = ((PsiExpressionList)this.myArgumentsList).getExpressions()).length) {
            return JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(expressions2[argId], right, left);
        }
        return false;
    }

    @NotNull
    private static PsiType[] typesAtSite(@NotNull PsiType[] types1, @NotNull PsiSubstitutor siteSubstitutor1) {
        PsiType[] types = PsiType.createArray((int)types1.length);
        for (int i = 0; i < types1.length; ++i) {
            types[i] = siteSubstitutor1.substitute(types1[i]);
        }
        return types;
    }

    @NotNull
    private static PsiSubstitutor calculateMethodSubstitutor(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiMethod method, @NotNull PsiSubstitutor siteSubstitutor, @NotNull PsiType[] types1, @NotNull PsiType[] types2, @NotNull LanguageLevel languageLevel) {
        PsiSubstitutor substitutor = PsiResolveHelper.SERVICE.getInstance((Project)method.getProject()).inferTypeArguments(typeParameters, types1, types2, languageLevel);
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)method)) {
            PsiClass aClass;
            PsiType type2;
            ProgressManager.checkCanceled();
            LOG.assertTrue(typeParameter != null);
            if (!substitutor.getSubstitutionMap().containsKey(typeParameter)) {
                type2 = siteSubstitutor.substitute(typeParameter);
                if (type2 instanceof PsiClassType && typeParameter.getOwner() == method && (aClass = ((PsiClassType)type2).resolve()) instanceof PsiTypeParameter && ((PsiTypeParameter)aClass).getOwner() == method) {
                    type2 = TypeConversionUtil.erasure((PsiType)type2, (PsiSubstitutor)siteSubstitutor);
                }
                substitutor = substitutor.put(typeParameter, type2);
                continue;
            }
            type2 = substitutor.substitute(typeParameter);
            if (!(type2 instanceof PsiClassType) || !((aClass = ((PsiClassType)type2).resolve()) instanceof PsiTypeParameter)) continue;
            substitutor = substitutor.put(typeParameter, (PsiType)JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass, siteSubstitutor));
        }
        return substitutor;
    }

    public void checkPrimitiveVarargs(@NotNull List<? extends CandidateInfo> conflicts, int argumentsCount) {
        PsiType componentType;
        PsiMethod method;
        if (JavaVersionService.getInstance().isAtLeast(this.myArgumentsList, JavaSdkVersion.JDK_1_7)) {
            return;
        }
        CandidateInfo objectVararg = null;
        for (CandidateInfo candidateInfo : conflicts) {
            PsiClassType classType;
            PsiType type2;
            ProgressManager.checkCanceled();
            method = (PsiMethod)candidateInfo.getElement();
            int parametersCount = method.getParameterList().getParametersCount();
            if (!method.isVarArgs() || parametersCount - 1 != argumentsCount || !Comparing.equal((Object)(componentType = ((PsiArrayType)(type2 = method.getParameterList().getParameters()[parametersCount - 1].getType())).getComponentType()), (Object)(classType = PsiType.getJavaLangObject((PsiManager)method.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)method.getProject()))))) continue;
            objectVararg = candidateInfo;
        }
        if (objectVararg != null) {
            for (CandidateInfo candidateInfo : conflicts) {
                ProgressManager.checkCanceled();
                method = (PsiMethod)candidateInfo.getElement();
                if (method == objectVararg.getElement() || !method.isVarArgs()) continue;
                int paramsCount = method.getParameterList().getParametersCount();
                PsiType type2 = method.getParameterList().getParameters()[paramsCount - 1].getType();
                componentType = ((PsiArrayType)type2).getComponentType();
                if (argumentsCount != paramsCount - 1 || !(componentType instanceof PsiPrimitiveType)) continue;
                conflicts.remove(objectVararg);
                break;
            }
        }
    }

    private static boolean isFunctionalTypeMoreSpecific(PsiExpression expr, PsiType sType, PsiType tType) {
        if (expr instanceof PsiParenthesizedExpression) {
            return JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(((PsiParenthesizedExpression)expr).getExpression(), sType, tType);
        }
        if (expr instanceof PsiConditionalExpression) {
            return JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(((PsiConditionalExpression)expr).getThenExpression(), sType, tType) && JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(((PsiConditionalExpression)expr).getElseExpression(), sType, tType);
        }
        if (expr instanceof PsiSwitchExpression) {
            return PsiUtil.getSwitchResultExpressions((PsiSwitchExpression)((PsiSwitchExpression)expr)).stream().allMatch(resultExpr -> JavaMethodsConflictResolver.isFunctionalTypeMoreSpecific(resultExpr, sType, tType));
        }
        if (expr instanceof PsiFunctionalExpression) {
            if (expr instanceof PsiLambdaExpression && !((PsiLambdaExpression)expr).hasFormalParameterTypes()) {
                return false;
            }
            if (expr instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)expr).isExact()) {
                return false;
            }
            if (LambdaUtil.isFunctionalType((PsiType)sType) && LambdaUtil.isFunctionalType((PsiType)tType) && !TypeConversionUtil.erasure((PsiType)tType).isAssignableFrom(sType) && !TypeConversionUtil.erasure((PsiType)sType).isAssignableFrom(tType)) {
                return InferenceSession.isFunctionalTypeMoreSpecificOnExpression(sType, tType, expr);
            }
        }
        return false;
    }

    private static enum Specifics {
        FIRST,
        SECOND,
        NEITHER;

    }
}

